/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.dto.mediatype;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

import lombok.Data;

@Data
public class OrgWechatDto {

	private Integer orgId;
	private Integer orgNumber;
	private String appId;//微信公众号id
	
	private boolean isUnifiedWechatAccount;
	
	
	public OrgWechatDto(Integer orgId, Integer orgNumber, String appId){
		this.orgId = orgId;
		this.orgNumber = orgNumber;
		this.appId = appId;
	}
	
	
	@Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }
    
    public boolean isUnifiedWechatAccount(){
        return this.isUnifiedWechatAccount;
    }
}

