/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.api;

import java.util.Date;

import com.baijia.tianxiao.dal.wechat.constant.WechatDataSyncType;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatDataSyncLog;

/**   
 * @title       : WechatDataSyncLogService 
 * @description : 微信数据同步日志service 
 * @author      : zhenyujian
 * @date        : 2016年11月2日 下午4:10:25 
 */
public interface WechatDataSyncLogService {
	
	/**
	 * @Description  : 根据日志状态判断是否已有任务在进行
	 * @Author       : zhenyujian
	 */
	boolean hasTaskOngoing(String authorizerAppId,WechatDataSyncType type);
	
	
	/**
	 * @Description  : 保存日志 
	 * @Author       : zhenyujian
	 */
	void saveOrUpdateInNewTransaction(OrgWechatDataSyncLog dataSyncLog);
	
	
	/**
	 * @Description  : 任务启动时生成初始日志
	 * @Author       : zhenyujian
	 */
	OrgWechatDataSyncLog buildDefaultLog(String authorizerAppId, WechatDataSyncType type, Date startTime, Integer amountExpected, Date expireTime);

}