/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatFansCumulateDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatFansSummaryDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatFansCumulate;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatFansSummary;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.SalWechatErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.StatisticsService;
import com.baijia.tianxiao.sal.wechat.constant.WechatApi;
import com.baijia.tianxiao.sal.wechat.dto.statistics.FansSCDto;
import com.baijia.tianxiao.sal.wechat.dto.statistics.FansSummaryDto;
import com.baijia.tianxiao.sal.wechat.helper.statistics.DataStatisticsApiHelper;
import com.baijia.tianxiao.sal.wechat.validator.WechatApiValidator;
import com.baijia.tianxiao.util.date.DateUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class StatisticsServiceImpl
implements StatisticsService {
    private static final Logger log = LoggerFactory.getLogger(StatisticsServiceImpl.class);
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private OrgWechatFansCumulateDao fansCumulateDao;
    @Autowired
    private OrgWechatFansSummaryDao fansSummaryDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public FansSCDto getFansStatistics(Integer orgId, Date beginDate, Date endDate) throws ParseException, BussinessException {
        long start = System.currentTimeMillis();
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(orgId);
        if (authorizerInfo == null) {
            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
        }
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
        WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.USER_GET_INFO);
        log.info("[Fans] Cost time = " + (System.currentTimeMillis() - start) + "\u6743\u9650\u5224\u65ad");
        String authorizerAppId = authorizerInfo.getAuthorizerAppId();
        Date yesterDay = DateUtil.getDiffDateTime((Date)DateUtil.getCurrentDate(), (int)-1);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        FansSCDto dto = null;
        OrgWechatFansCumulate fansCumulate = this.fansCumulateDao.getOrgWechatFansCumulate(authorizerAppId, yesterDay);
        Map fansSummaryMap = this.fansSummaryDao.mapKeyDateValueFansSummary(authorizerAppId, beginDate, endDate, sdf);
        log.info("[Fans] fansCumulate:{}, fansSummaryMap:{}", (Object)fansCumulate, (Object)fansSummaryMap);
        if (fansCumulate != null && fansSummaryMap.keySet().size() == DateUtil.getDateBetween((Date)beginDate, (Date)endDate).size()) {
            dto = new FansSCDto();
            dto.setStartDate(sdf.format(beginDate));
            dto.setEndDate(sdf.format(endDate));
            dto.setYtNewFans(fansCumulate.getNewUser());
            dto.setYtCancelFans(fansCumulate.getCancelUser());
            dto.setYtCumulateFans(fansCumulate.getCumulateUser());
            dto.setYtDate(sdf.format(yesterDay));
            dto.setYtFansDiff(fansCumulate.getFansDiff());
            ArrayList<FansSummaryDto> summaryDtoList = new ArrayList<FansSummaryDto>();
            for (OrgWechatFansSummary fansSummary : fansSummaryMap.values()) {
                if (fansSummary == null) continue;
                FansSummaryDto summaryDto = new FansSummaryDto();
                summaryDto.setCancelFans(fansSummary.getCancelUser());
                summaryDto.setNewFans(fansSummary.getNewUser());
                summaryDto.setFansDiff(fansSummary.getFansDiff());
                summaryDto.setDate(sdf.format(fansSummary.getRefDate()));
                summaryDtoList.add(summaryDto);
            }
            dto.setSummary(summaryDtoList);
        } else {
            dto = DataStatisticsApiHelper.getFansSCDto(authorizationInfo.getAuthorizerAccessToken(), beginDate, endDate, yesterDay);
            log.info("[Fans] Cost time = " + (System.currentTimeMillis() - start) + "\u8c03\u7528\u63a5\u53e3\u67e5\u8be2\u7c89\u4e1d\u8be6\u60c5");
            Date now = new Date();
            if (fansCumulate != null) {
                dto.setYtNewFans(fansCumulate.getNewUser());
                dto.setYtCancelFans(fansCumulate.getCancelUser());
                dto.setYtCumulateFans(fansCumulate.getCumulateUser());
                dto.setYtDate(sdf.format(yesterDay));
                dto.setYtFansDiff(fansCumulate.getFansDiff());
            } else if (StringUtils.isNotBlank((CharSequence)dto.getYtDate())) {
                this.saveFansCumulate(authorizerAppId, dto);
            } else {
                Date dayBeforeYesterDay = DateUtil.getDiffDateTime((Date)DateUtil.getCurrentDate(), (int)-2);
                FansSCDto preDto = DataStatisticsApiHelper.getFansSCDto(authorizationInfo.getAuthorizerAccessToken(), beginDate, endDate, dayBeforeYesterDay);
                if (StringUtils.isNotBlank((CharSequence)dto.getYtDate())) {
                    this.saveFansCumulate(authorizerAppId, preDto);
                } else {
                    dto.setYtNewFans(0);
                    dto.setYtCancelFans(0);
                    dto.setYtCumulateFans(0);
                    dto.setYtDate(sdf.format(dayBeforeYesterDay));
                    dto.setYtFansDiff(0);
                }
            }
            log.info("[Fans] FansSummaryDto list:{}", (Object)dto);
            for (FansSummaryDto summaryDto : dto.getSummary()) {
                ArrayList<OrgWechatFansSummary> fansSummaryList = new ArrayList<OrgWechatFansSummary>();
                if (fansSummaryMap.get(summaryDto.getDate()) == null && summaryDto.isFlag()) {
                    OrgWechatFansSummary fansSummary = new OrgWechatFansSummary();
                    fansSummary.setAuthorizerAppId(authorizerAppId);
                    fansSummary.setRefDate(sdf.parse(summaryDto.getDate()));
                    fansSummary.setNewUser(Integer.valueOf(summaryDto.getNewFans()));
                    fansSummary.setCancelUser(Integer.valueOf(summaryDto.getCancelFans()));
                    fansSummary.setCreateTime(now);
                    fansSummaryList.add(fansSummary);
                }
                if (fansSummaryList.size() <= 0) continue;
                try {
                    this.fansSummaryDao.saveAll(fansSummaryList, new String[0]);
                }
                catch (Exception e) {
                    log.warn("wechat - StatisticsServiceImpl - getFansStatistics - fansSummaryDao.saveAll error", (Throwable)e);
                }
            }
        }
        log.info("[Fans] Cost time = " + (System.currentTimeMillis() - start) + "\u83b7\u53d6\u7c89\u4e1d\u8d8b\u52bf\u603b\u65f6\u95f4");
        return dto;
    }

    void saveFansCumulate(String authorizerAppId, FansSCDto dto) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date now = new Date();
        OrgWechatFansCumulate fansCumulate = new OrgWechatFansCumulate();
        fansCumulate.setAuthorizerAppId(authorizerAppId);
        fansCumulate.setNewUser(Integer.valueOf(dto.getYtNewFans()));
        fansCumulate.setCancelUser(Integer.valueOf(dto.getYtCancelFans()));
        fansCumulate.setCumulateUser(Integer.valueOf(dto.getYtCumulateFans()));
        fansCumulate.setRefDate(sdf.parse(dto.getYtDate()));
        fansCumulate.setCreateTime(now);
        try {
            this.fansCumulateDao.save((Object)fansCumulate, Boolean.valueOf(true), new String[0]);
        }
        catch (Exception e) {
            log.warn("wechat - StatisticsServiceImpl - getFansStatistics - fansCumulateDao.save error", (Throwable)e);
        }
    }
}

