/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.common.service.WechatMsgRenderService;
import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgBaseInfoDto;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.push.constant.MsgType;
import com.baijia.tianxiao.dal.roster.dao.TxConsultUserDao;
import com.baijia.tianxiao.dal.roster.po.TxConsultUser;
import com.baijia.tianxiao.dal.wechat.constant.WechatOpenIdEntityType;
import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatOpenIdRecordDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatOpenIdRecord;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.WebResponse;
import com.baijia.tianxiao.dto.smstoken.StudentSmsTokenDto;
import com.baijia.tianxiao.enums.SalWechatErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.common.api.OrganizationInfoAPIService;
import com.baijia.tianxiao.sal.common.api.RedisDefaultService;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.AuthorizerInfoService;
import com.baijia.tianxiao.sal.wechat.api.MessagePushService;
import com.baijia.tianxiao.sal.wechat.api.UnifiedWechatAccountService;
import com.baijia.tianxiao.sal.wechat.api.WechatFreeVersionService;
import com.baijia.tianxiao.sal.wechat.api.WechatOpenIdRecordService;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.dto.common.WechatMessagePayload;
import com.baijia.tianxiao.sal.wechat.dto.msgfromapp.MessageContentDto;
import com.baijia.tianxiao.sal.wechat.dto.msgfromapp.MessageDto;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.TempMediaApiDto;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.media.WechatMediaApiHelper;
import com.baijia.tianxiao.sal.wechat.helper.sendmsg.customer.CustomerServiceApiHelper;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;
import com.baijia.tianxiao.sal.wechat.util.LocalFileHelper;
import com.baijia.tianxiao.sal.wechat.util.StorageUtil;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.ShortUrlUtil;
import com.baijia.tianxiao.util.WebResponseHelper;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MessagePushServiceImpl
implements MessagePushService {
    private static final Logger log = LoggerFactory.getLogger(MessagePushServiceImpl.class);
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private AuthorizerInfoService authorizerInfoService;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private WechatMsgRenderService wechatMsgRenderService;
    @Autowired
    private WechatFreeVersionService freeVersionService;
    @Autowired
    private WechatOpenIdRecordService wechatOpenIdRecordService;
    @Autowired
    private OrgWechatOpenIdRecordDao orgWechatOpenIdRecordDao;
    @Autowired
    private FansDao fansDao;
    @Autowired
    private TxConsultUserDao txConsultUserDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private UnifiedWechatAccountService unifiedWechatAccountService;
    @Autowired
    private OrganizationInfoAPIService organizationInfoAPIService;
    @Autowired
    private RedisDefaultService redisDefaultService;
    public static final long TEM_MIN = 600000L;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public WebResponse<?> handle(MessageDto message) {
        block37: {
            log.info("handle - message from app to wechat - message:{}", (Object)message);
            String unifiedWechatStrAdditatioin = null;
            try {
                boolean isUnifiedWechatAccount;
                Fans fans;
                AuthorizerInfo authorizerInfo = this.authorizerInfoService.getByOrgId(message.getOrgId());
                Integer orgId = message.getOrgId();
                String appId = null;
                String openId = null;
                OrgWechatOpenIdRecord record = null;
                if (authorizerInfo == null || this.freeVersionService.isFreeAccount(orgId)) {
                    appId = WechatProperties.getWechatAppidForFreeVersion();
                    record = this.orgWechatOpenIdRecordDao.getBy(appId, Long.valueOf(message.getOrgId().longValue()), message.getConsultUserId(), WechatOpenIdEntityType.CONSULT);
                    if (authorizerInfo == null) {
                        authorizerInfo = this.authorizerInfoService.getByAuthorizerAppId(appId);
                    }
                } else {
                    appId = authorizerInfo.getAuthorizerAppId();
                    record = this.orgWechatOpenIdRecordDao.getBy(appId, Long.valueOf(message.getOrgId().longValue()), message.getConsultUserId(), WechatOpenIdEntityType.CONSULT);
                }
                if (record != null) {
                    openId = record.getOpenId();
                } else {
                    TxConsultUser consulterUser = (TxConsultUser)this.txConsultUserDao.getById((Serializable)message.getConsultUserId(), new String[0]);
                    if (StringUtils.isNotBlank((CharSequence)consulterUser.getWeixinOpenId()) && consulterUser.getWeixinAppId().equals(appId)) {
                        openId = consulterUser.getWeixinOpenId();
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)openId)) {
                    fans = this.fansDao.getByOpenId(openId);
                    if (fans == null) {
                        throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.WECHAT_SEND_MESSAGE_FAIL_BY_SUBSCRIBE);
                    }
                    if (!fans.isSubscribed()) {
                        throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.WECHAT_SEND_MESSAGE_FAIL_BY_SUBSCRIBE);
                    }
                } else {
                    throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.WECHAT_SEND_MESSAGE_FAIL_BY_SUBSCRIBE);
                }
                message.setWechatOpenId(fans.getOpenId());
                message.setWechatAppid(fans.getAuthorizerAppId());
                String additional = null;
                boolean bl = isUnifiedWechatAccount = this.unifiedWechatAccountService.findMasterAccountWithAnyCampusOrgId(orgId, true) != null;
                if (!isUnifiedWechatAccount && this.freeVersionService.isFreeAccount(appId)) {
                    additional = this.permissionCheckAndGetAdditionalMsg4FreeVersion(message);
                }
                String unifiedChatUrl = null;
                log.debug("Unified wechat account =1={},{}", (Object)orgId, (Object)isUnifiedWechatAccount);
                if (isUnifiedWechatAccount) {
                    String chatPayload = this.redisDefaultService.getStr(WechatMessagePayload.getKey(message.getWechatOpenId()));
                    if (GenericsUtils.notNullAndEmpty((Object)chatPayload) && !this.checkChatPayLoad(chatPayload, message.getOrgId())) {
                        return WebResponseHelper.success();
                    }
                    log.info("current org:{} is a type of unifiedWechatAccount", (Object)orgId);
                    OrgAccount orgAccount = this.organizationInfoAPIService.findOrgAccountWithOrgId(Long.valueOf(orgId.longValue()));
                    unifiedChatUrl = this.unifiedWechatAccountService.createChatUrl(authorizerInfo.getAuthorizerAppId(), orgId, orgAccount.getNumber(), openId);
                    unifiedChatUrl = ShortUrlUtil.getShortUrl((String)unifiedChatUrl);
                    String fromat = "<a href='%s'>%s</a>";
                    unifiedWechatStrAdditatioin = additional = String.format(fromat, unifiedChatUrl, "\u673a\u6784\u56de\u590d\u6d88\u606f\u4e86,\u70b9\u6211\u4e0eTA\u6c9f\u901a\u5427");
                }
                AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(message.getWechatAppid());
                try {
                    if (message.getMsgT().intValue() == MsgType.TEXT.getValue()) {
                        this.handleTextMessage(authorizationInfo, message, additional);
                        break block37;
                    }
                    if (message.getMsgT().intValue() == MsgType.PICTURE.getValue()) {
                        this.handleImageMessage(authorizationInfo, message, additional);
                        break block37;
                    }
                    if (message.getMsgT().intValue() == MsgType.VOICE.getValue()) {
                        this.handleVoiceMessage(authorizationInfo, message, additional);
                        break block37;
                    }
                    if (message.getMsgT().intValue() == MsgType.CARD.getValue()) {
                        this.handleTextMessage(authorizationInfo, message, additional);
                        break block37;
                    }
                    return WebResponseHelper.error((UniverseErrorCode)SalWechatErrorCode.MESSAGE_PUSH_TO_WECHAT_NONSUUPORT_TYPE);
                }
                catch (WechatException e) {
                    if (authorizerInfo.isServiceApp() && authorizerInfo.isPassedVerify() && (e.getErrorCode().getSubsystemErrorCode() == SalWechatErrorCode.WECHAT_CANNOT_SENDMSG_TO_FANS.getSubsystemErrorCode() || e.getErrorCode().getSubsystemErrorCode() == SalWechatErrorCode.MESSAGE_PUSH_TO_WECHAT_FAIL_45047.getSubsystemErrorCode())) {
                        boolean sendTry = false;
                        try {
                            HashMap params = Maps.newHashMap();
                            if (this.freeVersionService.isFreeAccount(authorizationInfo.getAuthorizerAppId())) {
                                params.put("first", "\u673a\u6784\u8bf7\u6c42\u4e0e\u60a8\u8fdb\u884c\u6c9f\u901a\uff0c\u82e5\u540c\u610f\u8bf7\u70b9\u51fb\u6b64\u6d88\u606f\u8fdb\u5165\u804a\u5929\u9875\u9762\u3002\n");
                                params.put("url", this.permissionCheckAndGetImSite4FreeVersion(message));
                            } else if (isUnifiedWechatAccount) {
                                params.put("first", "\u673a\u6784\u8bf7\u6c42\u4e0e\u60a8\u8fdb\u884c\u6c9f\u901a\uff0c\u82e5\u540c\u610f\u8bf7\u70b9\u51fb\u6b64\u6d88\u606f\u8fdb\u5165\u804a\u5929\u9875\u9762\u3002\n");
                                params.put("url", unifiedChatUrl);
                                if (message.getMsgT().intValue() == MsgType.TEXT.getValue()) {
                                    String content = message.getContent().getText();
                                    if (GenericsUtils.notNullAndEmpty((Object)unifiedWechatStrAdditatioin)) {
                                        content = content.replace(unifiedWechatStrAdditatioin, "");
                                        log.info("content is :{} ", (Object)content);
                                        message.getContent().setText(content);
                                    }
                                }
                            } else {
                                params.put("first", "\u673a\u6784\u8bf7\u6c42\u4e0e\u60a8\u8fdb\u884c\u6c9f\u901a\uff0c\u82e5\u540c\u610f\u8bf7\u5728\u516c\u4f17\u53f7\u56de\u590d\u4efb\u610f\u6587\u5b57\u3002\n");
                                params.put("url", null);
                                sendTry = true;
                            }
                            params.put("remark", "");
                            params.put("keyword1", "\u6c9f\u901a\u8bf7\u6c42");
                            params.put("keyword2", message.getMsgId() + "");
                            if (message.getMsgT().intValue() == MsgType.TEXT.getValue()) {
                                params.put("keyword3", message.getContent().getText());
                            } else if (message.getMsgT().intValue() == MsgType.PICTURE.getValue()) {
                                params.put("keyword3", "[\u56fe\u7247]");
                            } else if (message.getMsgT().intValue() == MsgType.VOICE.getValue()) {
                                params.put("keyword3", "[\u8bed\u97f3]");
                            }
                            params.put("touser", message.getWechatOpenId());
                            Object msg = this.wechatMsgRenderService.render(Integer.valueOf(WechateTemplateMsgType.BATCH.getValue()), (Map)params);
                            this.wechatMsgRenderService.sendMsg(Long.valueOf(message.getOrgId().longValue()), msg);
                        }
                        catch (Exception e2) {
                            sendTry = false;
                            log.warn("WECHAT_SEND_MESSAGE_FAIL_BUT_TRY - fail - e:{}", (Throwable)e);
                            throw e;
                        }
                        if (sendTry) {
                            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.WECHAT_SEND_MESSAGE_FAIL_BUT_TRY);
                        }
                        break block37;
                    }
                    throw e;
                }
            }
            catch (BussinessException | WebServiceException | WechatException e) {
                log.warn("1handle - message from app to wechat - CustomException - message:{},e", (Object)message, (Object)e);
                throw e;
            }
            catch (Exception e) {
                log.error("1handle - message from app to wechat - Exception - message:{}", (Object)message);
                log.error("1handle - message from app to wechat - Exception - e", (Throwable)e);
                throw new WechatException((UniverseErrorCode)SalWechatErrorCode.MESSAGE_PUSH_TO_WECHAT_FAIL);
            }
        }
        return WebResponseHelper.success();
    }

    private boolean checkChatPayLoad(String chatPayload, Integer orgId) {
        log.info("[chatPayload]  json str is :  :{} ", (Object)chatPayload);
        WechatMessagePayload wmp = WechatMessagePayload.createWechatMessagePayload(chatPayload);
        log.info("[chatPayload] WechatMessagePayload is :{} ", (Object)wmp);
        if (wmp != null && (wmp.getFromType() == WechatMessagePayload.FROM_WECHAT || System.currentTimeMillis() - wmp.getLastChatTime() > 4000L || this.checkLastOrgIsNotMatch(wmp.getLastChatOrgId(), orgId))) {
            log.info("message from im or user leave im page last four second or lastChatOrgId not match the message from ");
            return true;
        }
        return false;
    }

    private boolean checkLastOrgIsNotMatch(Integer lastChatOrgId, Integer orgId) {
        return lastChatOrgId.intValue() != orgId.intValue();
    }

    void handleTextMessage(AuthorizationInfo authorizationInfo, MessageDto message, String additional) {
        String accessToken = authorizationInfo.getAuthorizerAccessToken();
        MessageContentDto content = message.getContent();
        String openId = message.getWechatOpenId();
        if (content.getText() == null) {
            content.setText("null");
        }
        if (additional != null) {
            String newText = "%s\n\n%s";
            newText = String.format(newText, content.getText(), additional);
            content.setText(newText);
        }
        CustomerServiceApiHelper.sendTextMsg(accessToken, openId, content.getText());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void handleImageMessage(AuthorizationInfo authorizationInfo, MessageDto message, String additional) throws Exception {
        File localFile;
        String openId;
        String accessToken;
        block8: {
            accessToken = authorizationInfo.getAuthorizerAccessToken();
            openId = message.getWechatOpenId();
            MessageContentDto content = message.getContent();
            localFile = null;
            byte[] data = null;
            if (content.getStorageId() != null && content.getStorageId() > 0) {
                OrgStorage orgStorage = this.orgStorageDao.getById(content.getStorageId().intValue());
                data = HttpClientUtils.download((String)StorageUtil.constructUrl(orgStorage));
                localFile = LocalFileHelper.saveToLocal(data, MIMEType.getMimeType((Integer)orgStorage.getMimeType()));
                break block8;
            }
            if (StringUtils.isNotBlank((CharSequence)content.getUrl())) {
                data = HttpClientUtils.download((String)content.getUrl());
                localFile = LocalFileHelper.saveToLocal(data, MIMEType.JPG);
                break block8;
            }
            log.info("error msg - message:{}", (Object)message);
            if (localFile == null) return;
            LocalFileHelper.deleteFile(localFile);
            return;
        }
        try {
            TempMediaApiDto mediaApiDto = WechatMediaApiHelper.uploadTempMedia(accessToken, MediaType.IMAGE, localFile);
            CustomerServiceApiHelper.sendImageMsg(accessToken, openId, mediaApiDto.getMediaId());
            if (additional != null) {
                CustomerServiceApiHelper.sendTextMsg(accessToken, openId, additional);
            }
            if (localFile == null) return;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (localFile == null) throw throwable;
                LocalFileHelper.deleteFile(localFile);
                throw throwable;
            }
        }
        LocalFileHelper.deleteFile(localFile);
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void handleVoiceMessage(AuthorizationInfo authorizationInfo, MessageDto message, String additional) throws Exception {
        String accessToken = authorizationInfo.getAuthorizerAccessToken();
        String openId = message.getWechatOpenId();
        MessageContentDto content = message.getContent();
        File localFile = null;
        try {
            OrgStorage orgStorage = this.orgStorageDao.getById(content.getStorageId().intValue());
            byte[] data = HttpClientUtils.download((String)StorageUtil.constructUrl(orgStorage));
            localFile = LocalFileHelper.saveToLocal(data, MIMEType.getMimeType((Integer)orgStorage.getMimeType()));
            TempMediaApiDto mediaApiDto = WechatMediaApiHelper.uploadTempMedia(accessToken, MediaType.VOICE, localFile);
            CustomerServiceApiHelper.sendVoiceMsg(accessToken, openId, mediaApiDto.getMediaId());
            if (additional != null) {
                CustomerServiceApiHelper.sendTextMsg(accessToken, openId, additional);
            }
            if (localFile == null) return;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                if (localFile == null) throw throwable;
                LocalFileHelper.deleteFile(localFile);
                throw throwable;
            }
        }
        LocalFileHelper.deleteFile(localFile);
        return;
    }

    String permissionCheckAndGetAdditionalMsg4FreeVersion(MessageDto message) throws Exception {
        String url = this.permissionCheckAndGetImSite4FreeVersion(message);
        OrgBaseInfoDto orgInfo = this.orgInfoDao.getBaseInfo(message.getOrgId().intValue());
        String fmt = "<a href=\"%s\">[%s]%s</a>";
        return String.format(fmt, url, orgInfo.getShortName(), "\u56de\u590d\u4f60\u6d88\u606f\u4e86\uff0c\u70b9\u51fb\u6211\u4e0e\u4ed6\u6c9f\u901a\u5427\uff01");
    }

    String permissionCheckAndGetImSite4FreeVersion(MessageDto message) throws Exception {
        Long studentId = this.wechatOpenIdRecordService.getStudentIdBy(message.getWechatAppid(), message.getOrgId().longValue(), message.getWechatOpenId());
        if (studentId == null) {
            throw new ParameterException("freeversion app msg push - studentId is null");
        }
        StudentSmsTokenDto token = new StudentSmsTokenDto(Long.valueOf(message.getOrgId().longValue()), message.getWechatAppid(), studentId, message.getWechatOpenId());
        return WechatWebAuthLinkBuilder.imSite(WebAuthScope.BASE, message.getWechatAppid(), token.toTokenStr());
    }
}

