/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatCustomMenuDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatCustomMenu;
import com.baijia.tianxiao.dal.wechat.po.UnifiedWechatAccount;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.SalWechatErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.sal.common.api.OrganizationInfoAPIService;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.CustomMenuService;
import com.baijia.tianxiao.sal.wechat.api.UnifiedWechatAccountService;
import com.baijia.tianxiao.sal.wechat.api.WechatFreeVersionService;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.constant.WechatApi;
import com.baijia.tianxiao.sal.wechat.constant.custommenu.FreeVersionMenuClick;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.dto.custommenu.CustomMenuBtn;
import com.baijia.tianxiao.sal.wechat.dto.custommenu.CustomMenuDto;
import com.baijia.tianxiao.sal.wechat.dto.custommenu.MenuConvertResult;
import com.baijia.tianxiao.sal.wechat.dto.mediatype.OrgWechatDto;
import com.baijia.tianxiao.sal.wechat.dto.menu.Menu;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.menu.WechatMenuApiHelper;
import com.baijia.tianxiao.sal.wechat.helper.menu.WechatMenuBtnBuilder;
import com.baijia.tianxiao.sal.wechat.helper.menu.WechatMenuJsonConverter;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;
import com.baijia.tianxiao.sal.wechat.util.MenuUtils;
import com.baijia.tianxiao.sal.wechat.validator.WechatApiValidator;
import com.baijia.tianxiao.util.GenericsUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomMenuServiceImpl
implements CustomMenuService {
    private static final Logger log = LoggerFactory.getLogger(CustomMenuServiceImpl.class);
    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private WechatFreeVersionService freeVersionService;
    @Autowired
    private OrgWechatCustomMenuDao orgWechatCustomMenuDao;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private UnifiedWechatAccountService unifiedWechatAccountService;
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;
    @Autowired
    private OrganizationInfoAPIService organizationInfoAPIService;

    @Override
    public boolean syncCustomMenu(int orgId) {
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveAndBuildCustomMenu(int orgId, String menuJson, Boolean ... needTrans) {
        AuthorizationInfo authorizationInfo = null;
        boolean needTrans_ = true;
        if (GenericsUtils.notNullAndEmpty((Object)needTrans)) {
            needTrans_ = needTrans[0];
        }
        authorizationInfo = needTrans_ ? this.authorizationInfoService.refreshAccessToken(orgId) : this.authorizationInfoDao.getByOrgId(Integer.valueOf(orgId));
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(Integer.valueOf(orgId));
        WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MENU);
        OrgAccount orgAccount = null;
        try {
            orgAccount = this.organizationInfoAPIService.findOrgAccountWithOrgId(Long.valueOf(orgId));
        }
        catch (Exception e) {
            GenericsUtils.logErrorAndInfo((Logger)log, (Exception)e, (String)"can not find orgAccount with orgId:{}", (Object[])new Object[]{orgId});
            return;
        }
        OrgWechatDto orgWechatDto = new OrgWechatDto(orgAccount.getId(), orgAccount.getNumber(), authorizerInfo.getAuthorizerAppId());
        MenuConvertResult result = null;
        try {
            UnifiedWechatAccount findUnifiedWechatAccountWithOrgId = this.unifiedWechatAccountService.findUnifiedWechatAccountWithOrgId(orgId);
            if (findUnifiedWechatAccountWithOrgId != null && findUnifiedWechatAccountWithOrgId.isMaster() && findUnifiedWechatAccountWithOrgId.isInitOver()) {
                orgWechatDto.setUnifiedWechatAccount(true);
            }
            result = WechatMenuJsonConverter.customJsonToWechatMenuJson(orgWechatDto, menuJson);
        }
        catch (ParameterException e) {
            log.warn("saveAndBuildCustomMenu- orgWechatDto:{},menuJson:{}", (Object)orgWechatDto, (Object)menuJson);
            log.warn("saveAndBuildCustomMenu- exception", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            log.warn("saveAndBuildCustomMenu- orgWechatDto:{},menuJson:{}", (Object)orgWechatDto, (Object)menuJson);
            log.error("saveAndBuildCustomMenu- exception", (Throwable)e);
            return;
        }
        OrgWechatCustomMenu menu = this.orgWechatCustomMenuDao.getByAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
        Date now = new Date();
        if (result.getWechatJson() != null) {
            if (menu == null) {
                menu = new OrgWechatCustomMenu();
                menu.setAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
                menu.setCreateTime(now);
                menu.setUpdateTime(now);
                menu.setJson(result.getCustomJson());
                this.orgWechatCustomMenuDao.save((Object)menu, Boolean.valueOf(true), new String[0]);
            } else {
                menu.setUpdateTime(now);
                menu.setJson(result.getCustomJson());
                this.orgWechatCustomMenuDao.update((Object)menu, Boolean.valueOf(true), new String[0]);
            }
            WechatMenuApiHelper.createMenu(authorizationInfo.getAuthorizerAccessToken(), result.getWechatJson());
        } else if (menu != null) {
            this.orgWechatCustomMenuDao.delById((Serializable)menu.getId());
            WechatMenuApiHelper.deleteMenu(authorizationInfo.getAuthorizerAccessToken());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CustomMenuDto getCustomMenu(int orgId) {
        CustomMenuDto dto = null;
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(Integer.valueOf(orgId));
        AuthorizationInfo authorizationInfo = this.authorizationInfoDao.getByOrgId(Integer.valueOf(orgId));
        if (authorizationInfo != null && authorizationInfo.isAccessTokenExpired()) {
            authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId);
        }
        WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MENU);
        OrgWechatCustomMenu menu = this.orgWechatCustomMenuDao.getByAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
        log.info("OrgWechatCustomMenu is :{} ", (Object)menu);
        if (menu == null) {
            try {
                WechatApiResponse result = WechatMenuApiHelper.getMenu(authorizationInfo.getAuthorizerAccessToken());
                String wechatJson = result.getJsonStr();
                MenuConvertResult mcResult = WechatMenuJsonConverter.wechatMenuJsonToCustomJson(wechatJson);
                if (mcResult.getCustomJson() != null) {
                    Date now = new Date();
                    menu = new OrgWechatCustomMenu();
                    menu.setAuthorizerAppId(authorizationInfo.getAuthorizerAppId());
                    menu.setCreateTime(now);
                    menu.setUpdateTime(now);
                    menu.setJson(mcResult.getCustomJson());
                    this.orgWechatCustomMenuDao.save((Object)menu, Boolean.valueOf(true), new String[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (menu != null) {
            dto = new CustomMenuDto();
            dto.setAuthorizerAppId(menu.getAuthorizerAppId());
            dto.setCreateTime(menu.getCreateTime());
            dto.setId(menu.getId());
            dto.setJson(menu.getJson());
        }
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public void updateOrgWechatMenu(AuthorizerInfo authorizerInfo, String needSetMenuJson, boolean needWebApiCheck) {
        if (authorizerInfo == null || GenericsUtils.isNullOrEmpty((Object)needSetMenuJson)) {
            return;
        }
        Integer orgId = authorizerInfo.getOrgId();
        if (needWebApiCheck) {
            AuthorizationInfo refreshAccessToken = this.authorizationInfoDao.getByOrgId(orgId);
            this.checkoutOrgWechatType(authorizerInfo, refreshAccessToken);
        }
        CustomMenuDto customMenuDto = null;
        try {
            customMenuDto = this.getCustomMenu(orgId);
        }
        catch (Exception e1) {
            GenericsUtils.logErrorAndInfo((Logger)log, (Exception)e1, (String)"can not get customMenu for {} ", (Object[])new Object[]{authorizerInfo});
            return;
        }
        OrgAccount orgAccount = null;
        try {
            orgAccount = this.organizationInfoAPIService.findOrgAccountWithOrgId(Long.valueOf(orgId.intValue()));
        }
        catch (Exception e) {
            GenericsUtils.logErrorAndInfo((Logger)log, (Exception)e, (String)"can not find orgAccount with orgId:{}", (Object[])new Object[]{orgId});
            return;
        }
        OrgWechatDto orgWechatDto = new OrgWechatDto(orgAccount.getId(), orgAccount.getNumber(), authorizerInfo.getAuthorizerAppId());
        Menu needSetMenu = null;
        MenuConvertResult mcResultForNeedSetMenu = WechatMenuJsonConverter.customJsonToWechatMenuJson(orgWechatDto, needSetMenuJson);
        needSetMenu = MenuUtils.covertJsonToMenu(mcResultForNeedSetMenu.getWechatJson());
        Menu customMenu = null;
        if (customMenuDto != null) {
            MenuConvertResult mcResult = WechatMenuJsonConverter.customJsonToWechatMenuJson(orgWechatDto, customMenuDto.getJson());
            customMenu = MenuUtils.covertJsonToMenu(mcResult.getWechatJson());
            MenuUtils.compareAndSetCustomMenu(needSetMenu, customMenu);
        } else {
            customMenu = needSetMenu;
        }
        MenuConvertResult wechatMenuJsonToCustomJson = WechatMenuJsonConverter.wechatMenuJsonToCustomJson(customMenu);
        log.info("reset customMenuJson :{} ", (Object)wechatMenuJsonToCustomJson.getCustomJson());
        try {
            this.saveAndBuildCustomMenu(orgId, wechatMenuJsonToCustomJson.getCustomJson(), false, false);
        }
        catch (Exception e) {
            GenericsUtils.logErrorAndInfo((Logger)log, (Exception)e, (String)"can not initCustomMenu for orgId:{}", (Object[])new Object[]{orgId});
        }
    }

    private void checkoutOrgWechatType(AuthorizerInfo authorizerInfo, AuthorizationInfo authorizationInfo) {
        try {
            WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.USER_WEBAUTH);
        }
        catch (BussinessException e) {
            throw new BussinessException((UniverseErrorCode)SalWechatErrorCode.WECHAT_WEB_AUTH_FAIL, "\u5f53\u524d\u516c\u4f17\u53f7\u65e0\u6cd5\u8fdb\u884c\u7f51\u9875\u6388\u6743,\u8bf7\u4f7f\u7528\u8ba4\u8bc1\u670d\u52a1\u53f7\u8fdb\u884c\u7edf\u4e00\u516c\u4f17\u53f7\u529f\u80fd\u7684\u8bbe\u7f6e");
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String getQuickMenuJson(int orgId) {
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(Integer.valueOf(orgId));
        OrgAccount orgAccount = null;
        try {
            orgAccount = this.organizationInfoAPIService.findOrgAccountWithOrgId(Long.valueOf(orgId));
        }
        catch (Exception e) {
            GenericsUtils.logErrorAndInfo((Logger)log, (Exception)e, (String)"can not find orgAccount with orgId:{}", (Object[])new Object[]{orgId});
            return "";
        }
        OrgWechatDto orgWechatDto = new OrgWechatDto(orgAccount.getId(), orgAccount.getNumber(), authorizerInfo.getAuthorizerAppId());
        boolean isUnifiedWechatAccount = false;
        UnifiedWechatAccount findMasterAccountWithAnyCampusOrgId = this.unifiedWechatAccountService.findMasterAccountWithAnyCampusOrgId(orgId, true);
        if (findMasterAccountWithAnyCampusOrgId != null && findMasterAccountWithAnyCampusOrgId.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue()) {
            log.info("wechat is under unified control :{} ", (Object)orgId);
            isUnifiedWechatAccount = true;
        }
        orgWechatDto.setUnifiedWechatAccount(isUnifiedWechatAccount);
        JSONObject json = new JSONObject();
        JSONArray btnArray = new JSONArray();
        ArrayList<CustomMenuBtn> subButton = new ArrayList<CustomMenuBtn>();
        subButton.add(CustomMenuBtn.buildViewBtn(MediaType.WANGXIAOZHUYE, orgWechatDto));
        subButton.add(CustomMenuBtn.buildViewBtn(MediaType.KECHENGLIEBIAO, orgWechatDto));
        subButton.add(CustomMenuBtn.buildViewBtn(MediaType.XIAOQUDIZHI, orgWechatDto));
        subButton.add(CustomMenuBtn.buildViewBtn(MediaType.DIANHUA, orgWechatDto));
        if (isUnifiedWechatAccount) {
            subButton.add(CustomMenuBtn.buildViewBtn(MediaType.ZAIXIANZIXUN, orgWechatDto));
        } else {
            subButton.add(CustomMenuBtn.buildTextBtn(MediaType.ZAIXIANZIXUN, "\u8bf7\u70b9\u51fb\u9875\u9762\u5de6\u4e0b\u65b9\u7684\u952e\u76d8\u6309\u94ae\uff0c\u5207\u6362\u5230\u5728\u7ebf\u4ea4\u8c08\u6a21\u5f0f\u3002", orgWechatDto));
        }
        CustomMenuBtn btn = CustomMenuBtn.buildHierarchyBtn(MediaType.WEIGUANWANG, orgWechatDto, subButton);
        btnArray.add((Object)btn.toJson());
        btnArray.add((Object)CustomMenuBtn.buildViewBtn(MediaType.YUYUESHITING, orgWechatDto).toJson());
        if (authorizerInfo.hasWebAuthPermission()) {
            subButton = new ArrayList();
            subButton.add(CustomMenuBtn.buildViewBtn(MediaType.XUESHENGZHONGXIN, orgWechatDto));
            subButton.add(CustomMenuBtn.buildViewBtn(MediaType.LAOSHIZHONGXIN, orgWechatDto));
            btn = CustomMenuBtn.buildHierarchyBtn(MediaType.GERENZHONGXIN, orgWechatDto, subButton);
            btnArray.add((Object)btn.toJson());
        }
        json.put((Object)"list", (Object)btnArray);
        return json.toString();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void mediaTypeConvert() {
        List list = this.orgWechatCustomMenuDao.getAll(new String[0]);
        log.info("mediaTypeConvert list size:{}", (Object)list);
        for (OrgWechatCustomMenu menu : list) {
            String json = menu.getJson();
            json = json.replace("\"mediaType\":\"15\",\"name\":\"\u9884\u7ea6\u8bd5\u542c\"", "\"mediaType\":\"23\",\"name\":\"\u9884\u7ea6\u8bd5\u542c\"");
            json = json.replace("\"mediaType\":\"15\",\"name\":\"\u6821\u533a\u5730\u5740\"", "\"mediaType\":\"20\",\"name\":\"\u9884\u7ea6\u8bd5\u542c\"");
            json = json.replace("\"mediaType\":\"15\",\"name\":\"\u5b66\u751f\u4e2d\u5fc3\"", "\"mediaType\":\"25\",\"name\":\"\u9884\u7ea6\u8bd5\u542c\"");
            json = json.replace("\"mediaType\":\"15\",\"name\":\"\u8001\u5e08\u4e2d\u5fc3\"", "\"mediaType\":\"26\",\"name\":\"\u9884\u7ea6\u8bd5\u542c\"");
            json = json.replace("\"mediaType\":\"6\",\"name\":\"400\u7535\u8bdd\"", "\"mediaType\":\"21\",\"name\":\"\u9884\u7ea6\u8bd5\u542c\"");
            json = json.replace("\"mediaType\":\"6\",\"name\":\"\u5728\u7ebf\u54a8\u8be2\"", "\"mediaType\":\"22\",\"name\":\"\u9884\u7ea6\u8bd5\u542c\"");
            menu.setJson(json);
            this.orgWechatCustomMenuDao.update((Object)menu, new String[0]);
        }
    }

    @Override
    public String createCampusListUrl(Integer orgNumber, String appId) {
        StringBuilder sb = new StringBuilder(WechatProperties.getWebMTianXiaoUrlPrefix());
        sb.append(String.format(WechatProperties.getCampusListUrlFormat(), orgNumber, appId));
        log.info("sb toString is :{} ", (Object)sb.toString());
        String campusListUrl = WechatWebAuthLinkBuilder.fansinfo(WebAuthScope.BASE, appId, sb.toString());
        return campusListUrl;
    }

    @Override
    public String createMenuForFreeVersion() {
        AuthorizerInfo authorizerInfo = this.freeVersionService.getFAAuthorizerInfo();
        AuthorizationInfo authorizationInfo = this.authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
        JSONObject json = new JSONObject();
        JSONArray btnArray = new JSONArray();
        btnArray.add((Object)WechatMenuBtnBuilder.clickBtn(FreeVersionMenuClick.STUDNET_CENTER.getName(), FreeVersionMenuClick.STUDNET_CENTER.getKey()));
        btnArray.add((Object)WechatMenuBtnBuilder.clickBtn(FreeVersionMenuClick.TEACHER_CENTER.getName(), FreeVersionMenuClick.TEACHER_CENTER.getKey()));
        json.put((Object)"button", (Object)btnArray);
        WechatMenuApiHelper.createMenu(authorizationInfo.getAuthorizerAccessToken(), json.toString());
        return json.toString();
    }

    @Override
    public void update400Menu() {
    }

    public static void main(String[] args) {
        System.out.println(MediaType.DIANHUA.getNote());
    }
}

