/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.dto.qrcode;

import com.baijia.tianxiao.sal.wechat.constant.qrcode.QRCodeType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class QRCodeSceneStr {
    private static final String SEPARATOR = "_";
    private static final String EQUAL = "=";
    private static final String QR_SCENE = "qrscene_";
    private static final String JSON_KEY_QRCODE_TYPE = "qr";
    protected QRCodeType qrCodeType;

    private void setQrCodeType(QRCodeType qrCodeType) {
    }

    public String getSceneStr() {
        return QRCodeSceneStr.createSceneStrParam(JSON_KEY_QRCODE_TYPE, this.qrCodeType.getValue());
    }

    public static QRCodeType parseQRCodeType(String str) {
        QRCodeType result = QRCodeType.getByVaule(QRCodeSceneStr.parseSceneStrParam(str, JSON_KEY_QRCODE_TYPE));
        if (null == result && StringUtils.isNotBlank((CharSequence)str) && (StringUtils.isNumeric((CharSequence)str) || str.startsWith(QR_SCENE))) {
            result = QRCodeType.QR_SCENE;
            if (StringUtils.isNumeric((CharSequence)str)) {
                result.setSceneId(Long.valueOf(str));
            } else if (str.startsWith(QR_SCENE)) {
                if (StringUtils.isNumeric((CharSequence)(str = str.replace(QR_SCENE, "")))) {
                    result.setSceneId(Long.valueOf(str));
                } else {
                    return null;
                }
            }
        }
        return result;
    }

    protected static String createSceneStrParam(String key, Object value) {
        return String.format("%s%s%s%s", key, EQUAL, value, SEPARATOR);
    }

    protected static String parseSceneStrParam(String str, String key) {
        String pattenStr;
        Pattern pattern;
        Matcher matcher;
        if (!str.startsWith(SEPARATOR)) {
            str = SEPARATOR + str;
        }
        if ((matcher = (pattern = Pattern.compile(pattenStr = String.format("%s%s%s([^%s]*)", SEPARATOR, key, EQUAL, SEPARATOR))).matcher(str)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static void main(String[] args) {
        String str = "qr=activity_aid=7_at=99_";
        String key = JSON_KEY_QRCODE_TYPE;
        String pattenStr = String.format("%s%s%s([^%s]*)", SEPARATOR, key, EQUAL, SEPARATOR);
        Pattern pattern = Pattern.compile(pattenStr);
        Matcher matcher = pattern.matcher(str);
        System.out.println((Object)QRCodeSceneStr.parseQRCodeType(str));
    }

    public QRCodeType getQrCodeType() {
        return this.qrCodeType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QRCodeSceneStr)) {
            return false;
        }
        QRCodeSceneStr other = (QRCodeSceneStr)o;
        if (!other.canEqual(this)) {
            return false;
        }
        QRCodeType this$qrCodeType = this.getQrCodeType();
        QRCodeType other$qrCodeType = other.getQrCodeType();
        return !(this$qrCodeType == null ? other$qrCodeType != null : !((Object)((Object)this$qrCodeType)).equals((Object)other$qrCodeType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QRCodeSceneStr;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        QRCodeType $qrCodeType = this.getQrCodeType();
        result = result * 59 + ($qrCodeType == null ? 43 : ((Object)((Object)$qrCodeType)).hashCode());
        return result;
    }

    public String toString() {
        return "QRCodeSceneStr(qrCodeType=" + (Object)((Object)this.getQrCodeType()) + ")";
    }
}

