/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.task;

import lombok.extern.slf4j.Slf4j;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatDataSyncLogDao;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.api.FansService;

/**   
 * @title       : FansSyncJob 
 * @description : 更新微信粉丝
 * @author      : zhenyujian
 * @date        : 2015年12月9日 上午12:51:54 
 */
@Slf4j
public class FansSyncJob implements Runnable{
	
	private FansService fansService;
	private String authorizerAppId;
	
	public FansSyncJob(FansService fansService, String authorizerAppId){
		this.fansService = fansService;
		this.authorizerAppId = authorizerAppId;
	}

	
	@Override
	public void run() {
		
		log.info("Wechat - FansSyncJob - run - start - authorizerAppId:{}",authorizerAppId);
		
		int amount = 0;
		
		//1. 执行粉丝同步
		try{
			Thread.currentThread().sleep(5000);//避免主从延迟
			amount = fansService.syncFansIncrement(authorizerAppId);
		}catch(WechatException e){
			log.error("Wechat - FansSyncJob - WechatException - e:{}",e);
		}catch(Exception e){
			log.error("Wechat - FansSyncJob - Exception - e:{}",e);
		}
		
		
		//2. 粉丝头像转换
		if(amount>0){
			try{
				Thread.currentThread().sleep(5000);//避免主从延迟
				fansService.batchConvertFansHeadImg(authorizerAppId);
			}catch(Exception e){
				log.error("Wechat - batchConvertFansHeadImg - Exception - e:{}",e);
			}
		}
		
	}
}

