/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper.qrcode;

import java.net.URLEncoder;

import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

import lombok.extern.slf4j.Slf4j;

import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.constant.qrcode.WechatQRCodeAction;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.WechatRemoteCallHelper;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;

import net.sf.json.JSONObject;

/**   
 * @title       : WechatQRCodeCaller 
 * @description : http://mp.weixin.qq.com/wiki/18/167e7d94df85d8389df6c94a7a8f78ba.html
 * @author      : zhenyujian
 * @date        : 2016年1月28日 上午11:52:19 
 */
@Slf4j
public class WechatQRCodeCaller {
	
	
	
	/**
	 * @Description  : 创建永久二维码
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月28日 上午11:53:27 
	 *
	 * @Return       : String
	 */
	public static WechatApiResponse createPermanentQRCode(String accessToken, String sceneStr){
		if(StringUtils.isBlank(sceneStr)){
			sceneStr = "unknown";
		}
		
		String json = "{\"action_name\": \"%s\", \"action_info\": {\"scene\": {\"scene_str\": \"%s\"}}}";
		try {
			json = String.format(json, WechatQRCodeAction.QR_LIMIT_STR_SCENE.getValue(), sceneStr);
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		StringBuilder builder = new StringBuilder("https://api.weixin.qq.com/cgi-bin/qrcode/create?");
		builder.append("&access_token=").append( accessToken );
		
		return WechatRemoteCallHelper.postJsonObj(builder.toString(), JSONObject.fromObject(json));
	}
	
	/**
	 * @Description  : 创建临时二维码, 有效期默认一个月
	 * @Author       : weihongyn
	 * @Date         : 2017年6月5日 下午4:44:00 
	 *
	 * @Return       : String
	 */
	public static WechatApiResponse createTemporaryQRCode(@NonNull String accessToken, @NonNull Integer sceneId){
		String json = "{\"expire_seconds\": 2592000, \"action_name\": \"%s\", \"action_info\": {\"scene\": {\"scene_id\": %s}}}";
		try {
			json = String.format(json, WechatQRCodeAction.QR_SCENE.getValue(), sceneId);
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		StringBuilder builder = new StringBuilder("https://api.weixin.qq.com/cgi-bin/qrcode/create?");
		builder.append("&access_token=").append( accessToken );
		
		return WechatRemoteCallHelper.postJsonObj(builder.toString(), JSONObject.fromObject(json));
	}
	
	
	/**
	 * @Description  : 下载二维码图片
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月28日 下午6:35:01 
	 *
	 * @Return       : byte[]
	 */
	public static byte[] downloadQRCodeImage(String ticket) throws WechatException, WebServiceException, Exception{
		StringBuilder builder = new StringBuilder();
		builder.append("https://mp.weixin.qq.com/cgi-bin/showqrcode?")
			   .append("ticket=").append( URLEncoder.encode(ticket,"utf8"));
		log.info("wechat - downloadQRCodeImage - url",builder.toString());
        return HttpClientUtils.download( builder.toString() );
    }
}

