package com.baijia.tianxiao.sal.wechat.helper.pay;

import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.WechatRemoteCallHelper;
import net.sf.json.JSONObject;

/**
 * Created by wengshengli on 2017/6/26.
 */
public class WechatPayApiCaller {

    /**
     * 统一下单
     *
     * @param accessToken
     * @param toOpenId
     * @param content
     * @return
     * @throws WechatException
     * @throws WebServiceException
     */
    public static WechatApiResponse sendTextMsg(String accessToken, String toOpenId, String content) throws WechatException, WebServiceException {
        String url = "https://api.mch.weixin.qq.com/pay/unifiedorder";

        JSONObject textMap = new JSONObject();
        textMap.put("content", content);

        JSONObject json = new JSONObject();
        json.put("touser", toOpenId);
        json.put("msgtype", "text");
        json.put("text", textMap);

        String jsonStr = json.toString();
        jsonStr = jsonStr.replace("\"content\":null", "\"content\":\"null\"");

        return WechatRemoteCallHelper.postJsonStr(url, jsonStr, true);
    }
}
