/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.dto.autoreply;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.dto.custommenu.CustomMenuBtn;

import lombok.Data;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/**   
 * @title       : KeywordReplyDto 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2016年1月3日 下午5:23:05 
 */
@Data
public class KeywordReplyDto {

	private Integer id;
	private JSONArray keywords;
	private Integer mediaType;
	private String mediaId;
	private String content;
	private String url;
	private String note;
	
	
	@Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }
    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
    
    
    public static void main(String gargs[]){
    	
    	JSONArray btnArray = new JSONArray();
//    	JSONObject obj = new JSONObject();
    	List<CustomMenuBtn> subButton = new ArrayList<CustomMenuBtn>();
    	subButton.add(CustomMenuBtn.buildTextBtn(MediaType.DIANHUA, "1", null));
    	subButton.add(CustomMenuBtn.buildTextBtn(MediaType.ZAIXIANZIXUN, "请点击页面左下方的键盘按钮，切换到在线交谈模式。", null));
    	CustomMenuBtn btn = CustomMenuBtn.buildHierarchyBtn(MediaType.WEIGUANWANG, null, subButton);
    	btnArray.add(btn.toJson());
    	System.out.println(btnArray);
    	
    }
}

