/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.constant.wechatmsg;

/**   
 * @title       : WechatMsgEvent 
 * @description : 微信事件消息事件类型 
 * 				  http://mp.weixin.qq.com/wiki/17/f298879f8fb29ab98b2f2971d42552fd.html#.E6.96.87.E6.9C.AC.E6.B6.88.E6.81.AF
 * @author      : zhenyujian
 * @date        : 2016年1月12日 下午8:05:53 
 */
public enum WechatMsgEvent{
	
	UNKNOWN("unknown"),
	
	SUBSCRIBE("subscribe"),//用户关注
	
	UNSUBSCRIBE("unsubscribe"),//用户取消关注
	
	SCAN("SCAN"),//用户已关注扫码
	
	LOCATION("LOCATION"),//上报地理位置
	
	MENU_CLICK("CLICK"),//自定义菜单 点击事件
	
	MENU_VIEW("VIEW"),//自定义菜单 跳转链接
	
	;

    private String value;
    
    public static WechatMsgEvent getByVaule(String value){
		for (WechatMsgEvent type : WechatMsgEvent.values()) {
			if(type.getValue().equals(value)){
				return type;
			}
        }
    	return UNKNOWN;
    }
    
    private WechatMsgEvent(String value) {
        this.value = value;
    }
    public String getValue() {
        return this.value;
    }
}

