/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.constant.qrcode;

import lombok.Getter;
import lombok.Setter;

/**   
 * @title       : WechatQRCodeType 
 * @description : 二维码类型 
 * @author      : zhenyujian
 * @date        : 2016年1月28日 上午11:40:24 
 */
public enum QRCodeType{
	
	CUSTOM_ACTIVITY("activity"),
	
	SUBCRIBE_WITH_ORG_ID("orgid"),
	
	QR_SCENE("老铁666"),
	;

	@Setter
    private String value;
	
	@Setter
    @Getter
    // 数据传输使用
    private Long sceneId;
    
    public static QRCodeType getByVaule(String value){
		for (QRCodeType type : QRCodeType.values()) {
			if(type.getValue().equals(value)){
				return type;
			}
        }
    	return null;
    }
    
    QRCodeType(String value) {
        this.value = value;
    }
    public String getValue() {
        return this.value;
    }
}

