/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.constant;

import java.util.Map;

import com.google.common.collect.Maps;

/**   
 * @title       : WechatErrorCode 
 * @description : 微信返回的错误码 错误信息 
 * 				  http://mp.weixin.qq.com/wiki/10/6380dc743053a91c544ffd2b7c959166.html
 * @author      : zhenyujian
 * @date        : 2016年1月14日 下午4:44:37 
 */
public enum WechatErrorCode {

	ec_1 (-1	, "系统繁忙，此时请开发者稍候再试" ),
	ec0 (0	, "请求成功" ),
	ec40001 (40001	, "获取access_token时AppSecret错误，或者access_token无效。请开发者认真比对AppSecret的正确性，或查看是否正在为恰当的公众号调用接口" ),
	ec40002 (40002	, "不合法的凭证类型" ),
	ec40003 (40003	, "不合法的OpenID，请开发者确认OpenID（该用户）是否已关注公众号，或是否是其他公众号的OpenID" ),
	ec40004 (40004	, "不合法的媒体文件类型" ),
	ec40005 (40005	, "不合法的文件类型" ),
	ec40006 (40006	, "不合法的文件大小" ),
	ec40007 (40007	, "不合法的媒体文件id" ),
	ec40008 (40008	, "不合法的消息类型" ),
	ec40009 (40009	, "不合法的图片文件大小" ),
	ec40010 (40010	, "不合法的语音文件大小" ),
	ec40011 (40011	, "不合法的视频文件大小" ),
	ec40012 (40012	, "不合法的缩略图文件大小" ),
	ec40013 (40013	, "不合法的AppID，请开发者检查AppID的正确性，避免异常字符，注意大小写" ),
	ec40014 (40014	, "不合法的access_token，请开发者认真比对access_token的有效性（如是否过期），或查看是否正在为恰当的公众号调用接口" ),
	ec40015 (40015	, "不合法的菜单类型" ),
	ec40016 (40016	, "不合法的按钮个数" ),
	ec40017 (40017	, "不合法的按钮个数" ),
	ec40018 (40018	, "不合法的按钮名字长度" ),
	ec40019 (40019	, "不合法的按钮KEY长度" ),
	ec40020 (40020	, "不合法的按钮URL长度" ),
	ec40021 (40021	, "不合法的菜单版本号" ),
	ec40022 (40022	, "不合法的子菜单级数" ),
	ec40023 (40023	, "不合法的子菜单按钮个数" ),
	ec40024 (40024	, "不合法的子菜单按钮类型" ),
	ec40025 (40025	, "不合法的子菜单按钮名字长度" ),
	ec40026 (40026	, "不合法的子菜单按钮KEY长度" ),
	ec40027 (40027	, "不合法的子菜单按钮URL长度" ),
	ec40028 (40028	, "不合法的自定义菜单使用用户" ),
	ec40029 (40029	, "不合法的oauth_code" ),
	ec40030 (40030	, "不合法的refresh_token" ),
	ec40031 (40031	, "不合法的openid列表" ),
	ec40032 (40032	, "不合法的openid列表长度" ),
	ec40033 (40033	, "不合法的请求字符，不能包含\\uxxxx格式的字符" ),
	ec40035 (40035	, "不合法的参数" ),
	ec40037 (40037	, "错误的微信模板消息id" ),
	ec40038 (40038	, "不合法的请求格式" ),
	ec40039 (40039	, "不合法的URL长度" ),
	ec40050 (40050	, "不合法的分组id" ),
	ec40051 (40051	, "分组名字不合法" ),
	ec40102 (40102	, "公众号所属行业与消息模板所属行业不一致" ),
	ec40117 (40117	, "分组名字不合法" ),
	ec40118 (40118	, "media_id大小不合法" ),
	ec40119 (40119	, "button类型错误" ),
	ec40120 (40120	, "button类型错误" ),
	ec40121 (40121	, "不合法的media_id类型" ),
	ec40132 (40132	, "微信号不合法" ),
	ec40137 (40137	, "不支持的图片格式" ),
	ec41001 (41001	, "缺少access_token参数" ),
	ec41002 (41002	, "缺少appid参数" ),
	ec41003 (41003	, "缺少refresh_token参数" ),
	ec41004 (41004	, "缺少secret参数" ),
	ec41005 (41005	, "缺少多媒体文件数据" ),
	ec41006 (41006	, "缺少media_id参数" ),
	ec41007 (41007	, "缺少子菜单数据" ),
	ec41008 (41008	, "缺少oauth code" ),
	ec41009 (41009	, "缺少openid" ),
	ec42001 (42001	, "access_token超时，请检查access_token的有效期，请参考基础支持-获取access_token中，对access_token的详细机制说明" ),
	ec42002 (42002	, "refresh_token超时" ),
	ec42003 (42003	, "oauth_code超时" ),
	ec42007 (42007	, "用户修改微信密码，accesstoken和refreshtoken失效，需要重新授权" ),
	ec43001 (43001	, "需要GET请求" ),
	ec43002 (43002	, "需要POST请求" ),
	ec43003 (43003	, "需要HTTPS请求" ),
	ec43004 (43004	, "需要接收者关注" ),
	ec43005 (43005	, "需要好友关系" ),
	ec44001 (44001	, "多媒体文件为空" ),
	ec44002 (44002	, "POST的数据包为空" ),
	ec44003 (44003	, "图文消息内容为空" ),
	ec44004 (44004	, "文本消息内容为空" ),
	ec45001 (45001	, "多媒体文件大小超过限制" ),
	ec45002 (45002	, "消息内容超过限制" ),
	ec45003 (45003	, "标题字段超过限制" ),
	ec45004 (45004	, "描述字段超过限制" ),
	ec45005 (45005	, "链接字段超过限制" ),
	ec45006 (45006	, "图片链接字段超过限制" ),
	ec45007 (45007	, "语音播放时间超过限制" ),
	ec45008 (45008	, "图文消息超过限制" ),
	ec45009 (45009	, "接口调用超过限制" ),
	ec45010 (45010	, "创建菜单个数超过限制" ),
	ec45015 (45015	, "回复时间超过限制" ),
	ec45016 (45016	, "系统分组，不允许修改" ),
	ec45017 (45017	, "分组名字过长" ),
	ec45018 (45018	, "分组数量超过上限" ),
	ec45027 (45027	, "消息模板和公众号所属行业关系不匹配" ),
	ec45026 (45026	, "消息模板绑定个数已达上限,无法继续绑定新模板" ),
	ec45028 (45028	, "群发数量已达上限 (微信规则 订阅号每日可发送1次，服务号每月可发送4次)" ),
	ec45047 (45047	, "客服接口下行条数超过上限" ),//https://segmentfault.com/q/1010000004193745
	ec46001 (46001	, "不存在媒体数据" ),
	ec46002 (46002	, "不存在的菜单版本" ),
	ec46003 (46003	, "不存在的菜单数据" ),
	ec46004 (46004	, "不存在的用户" ),
	ec47001 (47001	, "解析JSON/XML内容错误" ),
	ec48001 (48001	, "api功能未授权，请确认公众号已获得该接口，可以在公众平台官网-开发者中心页中查看接口权限" ),
	ec48003 (48003	, "首次使用群发功能前,请先登录微信公众平台在‘群发功能’中完成协议确认" ),//http://www.zhihu.com/question/30927648
	ec50001 (50001	, "用户未授权该api" ),
	ec50002 (50002	, "用户受限，可能是违规后接口被封禁" ),
	ec61023 (61023	, "refresh_token 已失效" ),
	ec61451 (61451	, "参数错误(invalid parameter)" ),
	ec61452 (61452	, "无效客服账号(invalid kf_account)" ),
	ec61453 (61453	, "客服帐号已存在(kf_account exsited)" ),
	ec61454 (61454	, "客服帐号名长度超过限制(仅允许10个英文字符，不包括@及@后的公众号的微信号)(invalid kf_acount length)" ),
	ec61455 (61455	, "客服帐号名包含非法字符(仅允许英文+数字)(illegal character in kf_account)" ),
	ec61456 (61456	, "客服帐号个数超过限制(10个客服账号)(kf_account count exceeded)" ),
	ec61457 (61457	, "无效头像文件类型(invalid file type)" ),
	ec61450 (61450	, "系统错误(system error)" ),
	ec61500 (61500	, "日期格式错误" ),
	ec65301 (65301	, "不存在此menuid对应的个性化菜单" ),
	ec65302 (65302	, "没有相应的用户" ),
	ec65303 (65303	, "没有默认菜单，不能创建个性化菜单" ),
	ec65304 (65304	, "MatchRule信息为空" ),
	ec65305 (65305	, "个性化菜单数量受限" ),
	ec65306 (65306	, "不支持个性化菜单的帐号" ),
	ec65307 (65307	, "个性化菜单信息为空" ),
	ec65308 (65308	, "包含没有响应类型的button" ),
	ec65309 (65309	, "个性化菜单开关处于关闭状态" ),
	ec65310 (65310	, "填写了省份或城市信息，国家信息不能为空" ),
	ec65311 (65311	, "填写了城市信息，省份信息不能为空" ),
	ec65312 (65312	, "不合法的国家信息" ),
	ec65313 (65313	, "不合法的省份信息" ),
	ec65314 (65314	, "不合法的城市信息" ),
	ec65316 (65316	, "该公众号的菜单设置了过多的域名外跳（最多跳转到3个域名的链接）" ),
	ec65317 (65317	, "不合法的URL" ),
	ec9001001 (9001001	, "POST数据参数不合法" ),
	ec9001002 (9001002	, "远端服务不可用" ),
	ec9001003 (9001003	, "Ticket不合法" ),
	ec9001004 (9001004	, "获取摇周边用户信息失败" ),
	ec9001005 (9001005	, "获取商户信息失败" ),
	ec9001006 (9001006	, "获取OpenID失败" ),
	ec9001007 (9001007	, "上传文件缺失" ),
	ec9001008 (9001008	, "上传素材的文件类型不合法" ),
	ec9001009 (9001009	, "上传素材的文件尺寸不合法" ),
	ec9001010 (9001010	, "上传失败" ),
	ec9001020 (9001020	, "帐号不合法" ),
	ec9001021 (9001021	, "已有设备激活率低于50%，不能新增设备" ),
	ec9001022 (9001022	, "设备申请数不合法，必须为大于0的数字" ),
	ec9001023 (9001023	, "已存在审核中的设备ID申请" ),
	ec9001024 (9001024	, "一次查询设备ID数量不能超过50" ),
	ec9001025 (9001025	, "设备ID不合法" ),
	ec9001026 (9001026	, "页面ID不合法" ),
	ec9001027 (9001027	, "页面参数不合法" ),
	ec9001028 (9001028	, "一次删除页面ID数量不能超过10" ),
	ec9001029 (9001029	, "页面已应用在设备中，请先解除应用关系再删除" ),
	ec9001030 (9001030	, "一次查询页面ID数量不能超过50" ),
	ec9001031 (9001031	, "时间区间不合法" ),
	ec9001032 (9001032	, "保存设备与页面的绑定关系参数错误" ),
	ec9001033 (9001033	, "门店ID不合法" ),
	ec9001034 (9001034	, "设备备注信息过长" ),
	ec9001035 (9001035	, "设备申请参数不合法" ),
	ec9001036 (9001036	, "查询起始值begin不合法" ),
	
	;
	
	private static Map<Integer, WechatErrorCode> map = Maps.newHashMap();
	
	static {
        for (WechatErrorCode ec : WechatErrorCode.values()) {
        	map.put(ec.getCode(), ec);
        }
    }
	
	public static WechatErrorCode getByCode(int code){
		return map.get(code);
	}
	
	
	private int code;
	private String msg;
	
	private WechatErrorCode(int code, String msg){
		this.code = code;
		this.msg = msg;
	}

	public int getCode() {
		return code;
	}
	public String getMsg() {
		return msg;
	}

	
	
	
}

