
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.wechat.api;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.dal.commons.UnifiedWechatAccountConfigDto;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.UnifiedWechatAccount;
import com.baijia.tianxiao.sal.wechat.dto.unifiedWechatAccount.CampusInfoDto;
import com.baijia.tianxiao.sal.wechat.dto.unifiedWechatAccount.CampusWechatInfoDto;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Nov 21, 2016
 * @Desc this guy is too lazy, nothing left.
 */
public interface UnifiedWechatAccountService {

    /**
     * 将一个分校区纳入统一公众号管理的范畴
     * 
     * @param orgId
     * @param masterOrgId
     * @return
     */
    public UnifiedWechatAccount addUnifiedWechatAccount(Long orgId, Long masterOrgId);

    /**
     * 根据机构number及地理位置查找当前纳入统一公众号校区管理的所有校区中最近的校区
     * 
     * @param orgNumber
     * @param longitude
     * @param latitude
     * @return
     */
    public CampusInfoDto findCloseOrgInfo(Long orgNumber, double longitude, double latitude);

    /**
     * 根据当前主账号获取所有分校区公众号设置状态信息,后期如果添加权限控制的话,可以扩展dto的属性
     * 
     * @param masterOrgId
     * @return
     */
    List<UnifiedWechatAccountConfigDto> orgCampusUnifiedWechatAccountStatus(Long masterOrgId);

    /**
     * @param orgNumber
     * @param openId
     * @return
     */
    List<CampusInfoDto> listAllCampusUseUnifiedAccount(Long orgNumber, String openId);

    /**
     * 根据orgNumber查找该机构所有纳入统一公众号管理的机构名称和课程列表的url
     * 
     * @param orgNumber
     * @return
     */
    Map<String, String> listAllCampusCoursesUrl(Long orgNumber);

    /**
     * 查找分校区公众号状态
     * 
     * @param orgId
     * @return
     */
    public Map<Integer, CampusWechatInfoDto> findCampusWechatStatus(Collection<Integer> orgIds, Integer masterOrgId);

    /**
     * 清除当前系统里面使用了该主账号作为公共公众号的机构记录
     * 
     * @param masterOrgId
     */
    public void clearUnifiedWechatAccountRecord(Long masterOrgId);

    /**
     * 创建机构的校区列表接口
     * 
     * @param orgNumber
     * @param appId
     * @return
     */
    String createCampusListUrl(Integer orgNumber, String appId);

    /**
     * 
     * 获取机构的IM聊天页面接口
     * 
     * @param authorizerInfo
     * @param orgId
     * @param number
     * @param openId
     * @return
     */
    String createChatUrl(String appId, Integer orgId, Integer number, String openId);

    /**
     * @param masterWechatAccount
     * @return
     */
    // Menu createUnifiedWechatAccountMenu(AuthorizerInfo masterWechatAccount);

    /**
     * 初始化统一公众号在unifiedWechatAccount 中的记录及修改底部菜单栏
     * 
     * @param masterOrgId
     * @param masterWechatAccount
     * @param masterHasBound
     */
    void initMasterAccount(Long masterOrgId, AuthorizerInfo masterWechatAccount, boolean masterHasBound);

    /**
     * @param orgId
     * @return
     */
    UnifiedWechatAccount findUnifiedWechatAccountWithOrgId(Integer orgId);

    /**
     * @param orgId
     * @param isInit
     * @return
     */

    UnifiedWechatAccount findMasterAccountWithAnyCampusOrgId(Integer orgId, Boolean isInit);

    /**
     * @param masterOrgId 
     * @param id
     */
    public void deleteSlaveCampus(Integer slaveOrgId, Integer masterOrgId);

    /**
     * @param orgId
     * @param mobile
     * @return
     */
    public String findWeixinFromCampusOrgWithMobile(Long orgId, String mobile, boolean isStudent);

}
