package com.baijia.tianxiao.sal.wechat.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.constants.MIMEType;
import com.baijia.tianxiao.dto.upload.UploadResult;
import com.baijia.tianxiao.dto.upload.UploadResult.UploadFile;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.google.common.collect.Maps;

/**
 * @title FileUploadUtils
 * @desc TODO
 * @author cxm
 * @date 2015年12月3日
 * @version 1.0
 */
@Slf4j
public class FileUploadUtils {

    public static UploadResult uploadToRemote(Long uid, File file, boolean watermark) {
        long start = System.currentTimeMillis();

        Map<String, File> files = Maps.newHashMap();
        Map<String, String> params = Maps.newHashMap();
        files.put("upfile", file);
        params.put("uid", WechatProperties.getUploadUidPrefix() + uid);
        String url = WechatProperties.getUploadServer();
        if (watermark) {
            url = url + "?watermark=1";
        }
        String response = HttpClientUtils.doPostFiles(url, params, files);
        log.debug("doUpload - uid:{}, file:{}, response:{}", uid, file, response);

        long end = System.currentTimeMillis();
        log.info("UploadService.uploadToRemote: uid:{},cost:{}", uid, (end - start));
        UploadResult result =  parseResponse(response);
        
        if(result!=null && result.getFiles()!=null){
        	String fmt = "%s%s_%s.%s";
        	for(UploadFile ufile:result.getFiles()){
        		String extension = file.getName().split("\\.")[1];
        		String server = "";
        		if(extension.equals(MIMEType.MP3.getExtension()) || extension.equals(MIMEType.AMR.getExtension()) ){
        			server = WechatProperties.getFileServer();
        		}else{
        			server = WechatProperties.getImageServer();
        		}
        		ufile.setUrl( String.format(fmt, server, ufile.getFid(), ufile.getSn(), extension) );
        	}
        }
        
        return result;
    }

    private static UploadResult parseResponse(String response) {
        if (StringUtils.isBlank(response)) {
            return null;
        }

        UploadResult uploadResult = null;
        try {
            JSONObject rootNode = JSONObject.fromObject(response);

            uploadResult = new UploadResult();
            uploadResult.setFail(rootNode.getInt("fail"));
            uploadResult.setOk(rootNode.getInt("ok"));
            uploadResult.setTotal(rootNode.getInt("total"));

            JSONArray filesArray = rootNode.getJSONArray("files");
            if (filesArray != null && filesArray.size() > 0) {
                List<UploadResult.UploadFile> list = new ArrayList<UploadResult.UploadFile>();
                UploadResult.UploadFile uFile = null;
                JSONObject fileNode = null;
                for (int i = 0; i < filesArray.size(); i++) {
                    uFile = uploadResult.new UploadFile();
                    fileNode = filesArray.getJSONObject(i);
                    uFile.setFid(fileNode.getString("fid"));
                    uFile.setKey(fileNode.getString("key"));
                    uFile.setSize(fileNode.getInt("size"));
                    uFile.setSn(fileNode.getString("sn"));
                    list.add(uFile);
                }
                uploadResult.setFiles(list);
            }
        } catch (Exception e) {
            log.error("parse response :{} catch error:{}", response, e);
        }
        log.info("parseResponse - response:{}, uploadResult:{}", response, uploadResult);
        return uploadResult;
    }

    
    
    public static UploadResult uploadToRemote(Long uid, String url, MIMEType mime, boolean watermark) {
    	
		File localFile = null;
		UploadResult result = null;
		byte[] data = null;
		try {
			//文件下载、上传
			data = HttpClientUtils.download( url );
			localFile = LocalFileHelper.saveToLocal(data, mime);
			result = FileUploadUtils.uploadToRemote(uid, localFile, false);
		} catch (Exception e) {
			log.error("uploadToRemote - exception",e);
			log.error("uploadToRemote - url:{},dataisnull:{}",url,data==null);
		} finally {
			if (localFile != null) {
				LocalFileHelper.deleteFile(localFile);
			}
		}
		
		return result;
    }
}
