/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper.menu;

import java.util.Map;

import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;

/**   
 * @Title       : WechatMenuApiCaller 
 * @Description : 微信api调用包装 主要负责返回结果处理、转换
 * @Author      : zhenyujian
 * @Date        : 2015年12月3日 下午4:09:56 
 */
public class WechatMenuApiHelper {
	
	
    /**
     * @Description  : 获取 自定义菜单
     * @Author       : zhenyujian
     * @Date         : 2015年12月4日 上午11:15:05 
     *
     * @Return       : WechatApiResponse
     */
    public static WechatApiResponse getMenu(String accessToken)  throws WechatException, WebServiceException{
        return WechatMenuApiCaller.getMenu(accessToken);
    }

    
    /**
     * @Description  : 删除自定义菜单
     * @Author       : zhenyujian
     * @Date         : 2015年12月4日 上午11:15:19 
     *
     * @Return       : WechatApiResponse
     */
    public static WechatApiResponse deleteMenu(String accessToken)  throws WechatException, WebServiceException{
        return WechatMenuApiCaller.deleteMenu(accessToken);
    }

    
    /**
     * @Description  : 创建自定义菜单
     * @Author       : zhenyujian
     * @Date         : 2015年12月4日 上午11:15:26 
     *
     * @Return       : WechatApiResponse
     */
    public static WechatApiResponse createMenu(String accessToken, Map<String, Object> menu)  throws WechatException, WebServiceException{
        return WechatMenuApiCaller.createMenu(accessToken, menu);
    }
    
    
    /**
     * @Description  : 创建自定义菜单
     * @Author       : zhenyujian
     * @Date         : 2016年1月8日 下午5:07:25 
     *
     * @Return       : WechatApiResponse
     */
    public static WechatApiResponse createMenu(String accessToken, String menuJson)  throws WechatException, WebServiceException{
        return WechatMenuApiCaller.createMenu(accessToken, menuJson);
    }


}

