package com.baijia.tianxiao.sal.wechat.dto.wechatapi;


import lombok.Data;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;


/**   
 * @title       : WechatApiResponse 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2015年12月12日 下午8:52:14 
 */
@Data
public class WechatApiResponse{
    
    private int code;
    private String msg;
    private String jsonStr;
    
    
    public WechatApiResponse() {}
    
    public WechatApiResponse(int code, String msg, String jsonStr) {
    	this.code = code;
    	this.msg = msg;
    	this.jsonStr = jsonStr;
    }
    
    public boolean isError(){
    	if(this.code!=0){
    		return true;
    	}
    	return false;
    }
    
    public JSONObject getRootJSONObj(){
    	if(StringUtils.isBlank(this.jsonStr)){
    		return null;
    	}
    	return JSONObject.fromObject(this.jsonStr);
    }
    
    public JSONArray getRootJSONArray(){
    	if(StringUtils.isBlank(this.jsonStr)){
    		return null;
    	}
    	return JSONArray.fromObject(this.jsonStr);
    }
    
    

	@Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }
    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
    
}
