
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.wechat.dto.unifiedWechatAccount;

import com.baijia.tianxiao.util.GenericsUtils;

import lombok.Data;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Nov 23, 2016
 * @Desc 纳入统一公众号的校区信息
 */
@Data
public class CampusInfoDto {

    private String orgName;
    private Integer orgNumber;
    private String mobile;
    private String mobileStr;
    private String mUrl; // 微官网主页url
    private String address;
    // 纬度
    private Double latitude;
    // 经度
    private Double longitude;
    private String locationUrl;
    private String chatUrl;

    public static CampusInfoDto newInstance(String orgName,Integer orgNumber, String mobile, String mUrl, String address,
        Double latitude, Double longitude, String locationUrl, String chatUrl) {
        CampusInfoDto cid = new CampusInfoDto();
        cid.orgName = orgName;
        cid.orgNumber = orgNumber;
        cid.mobile = mobile;
        cid.mUrl = mUrl;
        if(GenericsUtils.notNullAndEmpty(mobile)){
            cid.mobileStr = mobile.replace(",", "转");
        }
        cid.address = address;
        cid.latitude = latitude;
        cid.longitude = longitude;
        cid.chatUrl = chatUrl;
        cid.locationUrl = locationUrl;
        return cid;
    }
    
    public void setMobile(String mobile){
        this.mobile = mobile;
        if(GenericsUtils.notNullAndEmpty(mobile)){
            this.mobileStr = mobile.replace(",", "转");
        }
    }

}
