/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.dto.media;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.google.common.collect.Maps;

import lombok.Data;

/**   
 * @title       : NewsMediaDto 
 * @description : 微信上传图文素材 参数
 * @author      : zhenyujian
 * @date        : 2015年12月24日 上午10:56:21 
 */
@Data
public class MediaNewsAddDto {
	//参数说明见 http://mp.weixin.qq.com/wiki/14/7e6c03263063f4813141c3e17dd4350a.html
	private String title;
	private String thumbMediaId;
	private String atuthor;
	private String digest;
	private Integer showCoverPic;
	private String content;
	private String contentSourceUrl;
	
	
	public static Map<String, Object> buildJsonMapByList(List<MediaNewsAddDto> list){
		Map<String, Object> root = Maps.newHashMap();
		
		List<Map<String, Object>> articles = new ArrayList<Map<String, Object>>();
		root.put("articles", articles);
		if(list!=null && !list.isEmpty()){
			Map<String, Object> article = Maps.newHashMap();
			for(MediaNewsAddDto dto:list){
				article = Maps.newHashMap();
				article.put("title", dto.getTitle());
				article.put("thumb_media_id", dto.getThumbMediaId());
				article.put("author", dto.getAtuthor());
				article.put("digest", dto.getDigest());
				article.put("show_cover_pic", dto.getShowCoverPic());
				article.put("content", dto.getContent());
				article.put("content_source_url", dto.getContentSourceUrl());
				articles.add(article);
			}
		}
		return root;
	}
	
	@Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }
}

