/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.dto.fans;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

import com.baijia.tianxiao.dal.wechat.po.Fans;

import lombok.Data;

/**   
 * @title       : FansDetailDto 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2015年12月8日 下午9:11:53 
 */
@Data
public class FansDetailDto {
    private Integer id;
	private String openId;
	private String nick;//微信昵称
	private String remark;//公众号为其设置的备注名称
	private String showName;//展示名称
	private Integer subscribe;//是否关注
	private Long subscribeTime;//关注时间 秒级时间戳
	private String headImgUrl;//头像
	private String country;//国家
	private String province; //省份
	private String city;//城市
	private Integer chat;//是否可以聊天
	
	
	public static FansDetailDto build(Fans fans){
		if(fans == null){
			return null;
		}
		FansDetailDto dto = new FansDetailDto();
		dto.setId( fans.getId() );
		dto.setOpenId( fans.getOpenId() );
		dto.setNick( fans.getNick() );
		dto.setRemark( fans.getRemark() );
		dto.setShowName( fans.getShowName() );
		dto.setSubscribe( fans.getSubscribe() );
		dto.setSubscribeTime( fans.getSubscribeTime().getTime() );
		dto.setHeadImgUrl( fans.getHeadImgUrl() );
		dto.setCountry( fans.getCountry() );
		dto.setProvince( fans.getProvince() );
		dto.setCity( fans.getCity() );
		dto.setChat( fans.isAllowToChat() ? 1:0 );
		return dto;
	}
	
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }
	
}

