package com.baijia.tianxiao.sal.wechat.dto.JSSDK;

import com.baijia.tianxiao.sal.wechat.util.JSSDKUtils;

import java.util.Date;
import java.util.UUID;

import lombok.Data;

/**
 * @author Rezar
 * @createDate :Jun 30, 2016 2:42:23 PM
 * @desc : JSSDK js文件中用于验证的一些参数
 */
@Data
public class JsSDKParamDto {

    private long timestamp; // timestamp
    private String nonceStr; // nonceStr
    private String signature; // signature
    private String appId; // 公众号的全局唯一标识

    // 非必填
    private String accessToken; // accessToken
    private String jsapiTicker; // jsapi_ticket

    /**
     * 
     * @param jsapiTicket是公众号用于调用微信JS接口的临时票据。正常情况下，jsapi_ticket的有效期为7200秒
     * @param url 当前调用JSSDK接口的页面url
     * @param accessToken access_token是公众号的全局唯一票据，公众号调用各接口时都需使用access_token
     * 
     *            <br/>
     *            appId: '', // 必填，公众号的唯一标识<br/>
     *            timestamp: , // 必填，生成签名的时间戳<br/>
     *            nonceStr: '', // 必填，生成签名的随机串<br/>
     *            signature: '',// 必填，签名，见附录1<br/>
     * 
     * @return
     */
    public static JsSDKParamDto generate(String jsapiTicket, String url, String accessToken, String appId) {
        long time = new Date().getTime();
        String randomStr = UUID.randomUUID().toString();
        String shaStrFomat = "jsapi_ticket=%s&noncestr=%s&timestamp=%s&url=%s";
        String shaStr = String.format(shaStrFomat, jsapiTicket, randomStr, time, url);
        String signature = JSSDKUtils.sha1Encrypt(shaStr);
        JsSDKParamDto jspd = new JsSDKParamDto();
        jspd.setAppId(appId);
        jspd.setAccessToken(accessToken);
        jspd.setJsapiTicker(jsapiTicket);
        jspd.setNonceStr(randomStr);
        jspd.setTimestamp(time);
        jspd.setSignature(signature);
        return jspd;
    }

}
