/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.constant.custommenu;

import java.util.Map;
import com.google.common.collect.Maps;

/**   
 * @title       : FreeVersionMenuClick 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2016年8月29日 上午12:28:44 
 */
public enum FreeVersionMenuClick {
	
	STUDNET_CENTER("学生个人中心","student"),
	
	TEACHER_CENTER("老师个人中心","teacher"),
	;

	private String name;
    private String key;
    
    private static Map<String, FreeVersionMenuClick> map = Maps.newHashMap();
    static {
        for (FreeVersionMenuClick p : values()) {
            map.put(p.getKey(), p);
        }
    }
    
    private FreeVersionMenuClick(String name, String key) {
    	this.name = name;
        this.key = key;
    }
    public String getKey() {
        return this.key;
    }
    public String getName() {
        return this.name;
    }
    
    public static FreeVersionMenuClick getByKey(String key){
    	return map.get(key);
    }
}

