
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2015 All Rights Reserved.
 */
    
package com.baijia.tianxiao.sal.wechat.constant;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.ErrorSide;
import com.baijia.tianxiao.enums.Platform;
import com.baijia.tianxiao.enums.Subsystem;


public enum SalWechatErrorCode implements UniverseErrorCode {
    
	//2016001009
	
    UNKNOW(ErrorSide.SERVER, Subsystem.UNKNOW, Platform.UNKNOW, 1 ,"未知类型错误"),
    
    WECHAT_API_RETURN_ERROR(1001, "微信接口返回错误"),
    
    WECHAT_ACCESS_TOKEN_INVALID(1002,"无效的微信access token"),  
    
    WECHAT_PERMISSION_DENIED(1003, "访问微信接口失败, 原因:公众号具备的权限不足。"
    									+ "\n建议:"
    									+ "\n 1.确认微信公众号是否已完成资质认证。"
    									+ "\n 2.确认微信公众号是否将部分功能权限授予了其它第三方平台。"
    									+ "\n 3.如确认无误,请尝试重新执行公众号绑定流程,再次授权。"
    									+ "\n\n(推荐绑定已认证的服务号，以确保具备所有权限。)"),
    
    WECHAT_AUTHORIZATION_DENIED(1004, "访问微信接口失败, 原因:公众号授予平台的权限不足。"
									+ "\n建议:"
									+ "\n 1.确认微信公众号是否将部分功能权限授予了其它第三方平台"
									+ "\n 2.如确认无误,请尝试重新执行公众号绑定流程,再次授权。"
									+ "\n\n(推荐绑定已认证的服务号，以确保具备所有权限。)"),
									
	WECHAT_DATA_IN_SYNC(1005,"数据同步中,请稍后刷新页面重试。"),
									
	WECHAT_CANNOT_SENDMSG_TO_FANS(1009,"访客已48小时未与公众号交互，无法收到消息。"),
	
	WECHAT_SYSTEM_ERROR(1010,"微信服务器繁忙，此时稍后再试"),
	
	WECHAT_UNBIND_TEMPLATE(1011,"公众号没有绑定该消息模板或绑定失败，无法发送消息"),
	
	WECHAT_WEB_AUTH_FAIL(1012,"微信网页授权失败"),
	
	WECHAT_UNBIND_ORG(1013,"访问失败,该微信公众号没有绑定跟谁学机构账号。"),
	
	WECHAT_ILLEGAL_OPENID(1014, "不合法的openId"),
	
	WECHAT_SEND_MESSAGE_FAIL(1015, "向粉丝发送消息失败 (粉丝已取消关注或48小时内未与公众号主动交互则无法向其发送消息)"),
	
	WECHAT_REFRESH_ACCESSTOKEN_FAIL(1016, "微信令牌获取失败,请稍后重试。"),
	
	WECHAT_WRONG_COMPONET(1017, "公众平台令牌验证错误,请确认访问环境是否正确。"),
	
	WECHAT_WRONG_TEMPLATE_ID(1018, "模板消息ID错误。"),
	
	WECHAT_SEND_MESSAGE_FAIL_BUT_TRY(1019, "对方超过48小时未与公众号互动，无法收到消息。已向对方发送互动申请，待回复后可正常沟通。"),

	WECHAT_SEND_MESSAGE_FAIL_BY_SUBSCRIBE(1020, "发送失败，粉丝已取消关注。"),
	
	WECHAT_REFRESH_TOKEN_IS_INVALID(1021, "微信令牌失效，请到微信平台取消授权，然后重新执行绑定流程。"),

	
	MESSAGE_PUSH_TO_WECHAT_NONSUUPORT_TYPE(2001, "不支持的消息类型"),
    
    MESSAGE_PUSH_TO_WECHAT_FAIL(2002, "向微信推送消息失败"),
    
    MESSAGE_PUSH_TO_WECHAT_FAIL_45047(2003, "消息推送条数已达上限，需等待用户回复后可继续发送。"),
    
    
    
    
    
    ORG_NUBIND_WECHATAPP(3001,"操作失败,您还没有绑定微信公众号。"),
    
    ORG_ALREADY_BIND_WECHATAPP(3002,"操作失败,该账号已绑定了其它微信公众号。"),
    
    WECHATAPP_ALREADY_BIND_ORG(3003,"操作失败,该微信微信公众号已经绑定了其它机构。"),
    
    
			
    ;
    
    private ErrorSide errorSide;
    private Subsystem subsystem;
    private Platform platform;
    private int code;
    private String message;
    
    private SalWechatErrorCode(ErrorSide errorSide, Subsystem subsystem, Platform platform, int code, String msg){
        this.errorSide = errorSide;
        this.subsystem = subsystem;
        this.platform = platform;
        this.code = code;
        this.message = msg;
    }
    
    private SalWechatErrorCode(int code, String msg) {
        this(ErrorSide.SERVER, Subsystem.WECHAT, Platform.UNKNOW, code, msg);
    }
    
    /* (non-Javadoc)
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getErrorSide()
     */
    @Override
    public ErrorSide getErrorSide() {
        return errorSide;
    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getSystem()
     */
    @Override
    public Subsystem getSystem() {
        return subsystem;
    }

    /* (non-Javadoc)
     * @see com.baijia.tianxiao.dto.UniverseErrorCode#getPlatform()
     */
    @Override
    public Platform getPlatform() {
        return platform;
    }

    @Override
    public int getSubsystemErrorCode(){
        return code;
    }
    
    @Override
    public String getMessage(){
        return message;
    }
    
    @Override
    public SalWechatErrorCode fromCode(int code){
        for (SalWechatErrorCode errorCode:values()){
            if (errorCode.getSubsystemErrorCode()==code){
                return errorCode;
            }
        }
        return UNKNOW;
    }

}

    