/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.validator;

import com.baijia.tianxiao.exception.ParameterException;


/**   
 * @title       : FansValidator 
 * @description : 微信粉丝相关接口参数验证
 * @author      : zhenyujian
 * @date        : 2015年12月17日 下午12:03:39 
 */
public class FansValidator {

	
	/**
	 * @Description  : 粉丝备注  0-10个字符
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月17日 下午1:51:21 
	 *
	 * @Return       : void
	 */
	public static void _4Remark(String remark) throws ParameterException{
		if(remark==null){
			throw new ParameterException("备注名不能为空");
		}
		
		if( !(remark.length()>=0 && remark.length()<=10) ){
			throw new ParameterException("备注名最多允许输入10个字符");
    	}
	}
}

