/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatFansCumulateDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatFansSummaryDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatFansCumulate;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatFansSummary;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.StatisticsService;
import com.baijia.tianxiao.sal.wechat.constant.SalWechatErrorCode;
import com.baijia.tianxiao.sal.wechat.constant.WechatApi;
import com.baijia.tianxiao.sal.wechat.dto.statistics.FansSCDto;
import com.baijia.tianxiao.sal.wechat.dto.statistics.FansSummaryDto;
import com.baijia.tianxiao.sal.wechat.helper.statistics.DataStatisticsApiHelper;
import com.baijia.tianxiao.sal.wechat.validator.WechatApiValidator;
import com.baijia.tianxiao.util.date.DateUtil;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

@Service
@Slf4j
public class StatisticsServiceImpl implements StatisticsService{

	@Autowired
    private AuthorizerInfoDao authorizerInfoDao;
	@Autowired
	private AuthorizationInfoDao authorizationInfoDao;
	@Autowired
    private AuthorizationInfoService authorizationInfoService;
	@Autowired
	private OrgWechatFansCumulateDao fansCumulateDao;
	@Autowired
	private OrgWechatFansSummaryDao fansSummaryDao;
	
	
	
	@Transactional(rollbackFor = Exception.class)
	@Override
	public FansSCDto getFansStatistics(Integer orgId, Date beginDate, Date endDate) throws ParseException, BussinessException  {
	    long start = System.currentTimeMillis(); 
		AuthorizerInfo authorizerInfo = authorizerInfoDao.getByOrgId(orgId);
		if(authorizerInfo == null){
			throw new BussinessException(SalWechatErrorCode.ORG_NUBIND_WECHATAPP);
		}
		
		AuthorizationInfo authorizationInfo = authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());
		
		//权限判断
		WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.USER_GET_INFO);
		log.info("[Fans] Cost time = " + (System.currentTimeMillis() - start) + "权限判断");
		
		String authorizerAppId = authorizerInfo.getAuthorizerAppId();
		Date yesterDay = DateUtil.getDiffDateTime(DateUtil.getCurrentDate(), -1);
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		OrgWechatFansCumulate fansCumulate;
		Map<String, OrgWechatFansSummary> fansSummaryMap;
		FansSCDto dto = null;
		
		//本地查询数据
		fansCumulate = fansCumulateDao.getOrgWechatFansCumulate(authorizerAppId, yesterDay);
		fansSummaryMap = fansSummaryDao.mapKeyDateValueFansSummary(authorizerAppId, beginDate, endDate, sdf);
		log.info("[Fans] fansCumulate:{}, fansSummaryMap:{}",fansCumulate, fansSummaryMap);
		
		
		if(fansCumulate!=null && fansSummaryMap.keySet().size() == DateUtil.getDateBetween(beginDate, endDate).size()){
			dto = new FansSCDto();
			dto.setStartDate( sdf.format(beginDate) );
			dto.setEndDate( sdf.format(endDate) );
			dto.setYtNewFans( fansCumulate.getNewUser() );
			dto.setYtCancelFans( fansCumulate.getCancelUser() );
			dto.setYtCumulateFans( fansCumulate.getCumulateUser() );
			dto.setYtDate( sdf.format(yesterDay) );
			dto.setYtFansDiff( fansCumulate.getFansDiff() );
			
			List<FansSummaryDto> summaryDtoList = new ArrayList<FansSummaryDto>();
			for(OrgWechatFansSummary fansSummary : fansSummaryMap.values()){
			    if (fansSummary != null) {
			        FansSummaryDto summaryDto = new FansSummaryDto();
	                summaryDto.setCancelFans( fansSummary.getCancelUser() );
	                summaryDto.setNewFans( fansSummary.getNewUser() );
	                summaryDto.setFansDiff( fansSummary.getFansDiff() );
	                summaryDto.setDate( sdf.format(fansSummary.getRefDate()) );
	                summaryDtoList.add( summaryDto );
			    }
			}
			dto.setSummary(summaryDtoList);
			
			
		}else{
			//调用接口查询数据
			dto = DataStatisticsApiHelper.getFansSCDto(authorizationInfo.getAuthorizerAccessToken(), beginDate, endDate, yesterDay);
			log.info("[Fans] Cost time = " + (System.currentTimeMillis() - start) + "调用接口查询粉丝详情");
			Date now  = new Date();
			
			if(fansCumulate!=null){
				dto.setYtNewFans( fansCumulate.getNewUser() );
				dto.setYtCancelFans( fansCumulate.getCancelUser() );
				dto.setYtCumulateFans( fansCumulate.getCumulateUser() );
				dto.setYtDate( sdf.format(yesterDay) );
				dto.setYtFansDiff( fansCumulate.getFansDiff() );
			}else{
				if( StringUtils.isNotBlank(dto.getYtDate()) ){
					saveFansCumulate(authorizerAppId, dto);
				}else{
					Date dayBeforeYesterDay = DateUtil.getDiffDateTime(DateUtil.getCurrentDate(), -2);
					FansSCDto preDto = DataStatisticsApiHelper.getFansSCDto(authorizationInfo.getAuthorizerAccessToken(), beginDate, endDate, dayBeforeYesterDay);
					if( StringUtils.isNotBlank(dto.getYtDate()) ){
						saveFansCumulate(authorizerAppId, preDto);
					}else{
						dto.setYtNewFans( 0 );
						dto.setYtCancelFans( 0 );
						dto.setYtCumulateFans( 0 );
						dto.setYtDate( sdf.format(dayBeforeYesterDay) );
						dto.setYtFansDiff( 0 );
					}
				}
			}
			
			log.info("[Fans] FansSummaryDto list:{}", dto);
			for(FansSummaryDto summaryDto : dto.getSummary()){
				List<OrgWechatFansSummary> fansSummaryList = new ArrayList<OrgWechatFansSummary>();
				if( fansSummaryMap.get(summaryDto.getDate())==null && summaryDto.isFlag() == true ){
					OrgWechatFansSummary fansSummary = new OrgWechatFansSummary();
					fansSummary.setAuthorizerAppId( authorizerAppId );
					fansSummary.setRefDate( sdf.parse(summaryDto.getDate()) );
					fansSummary.setNewUser( summaryDto.getNewFans() );
					fansSummary.setCancelUser( summaryDto.getCancelFans() );
					fansSummary.setCreateTime( now );
					fansSummaryList.add(fansSummary);
				}
				if(fansSummaryList.size()>0){
					try{
						fansSummaryDao.saveAll(fansSummaryList);
					}catch(Exception e){
						log.warn("wechat - StatisticsServiceImpl - getFansStatistics - fansSummaryDao.saveAll error",e);
					}
				}
			}
		}
		
		log.info("[Fans] Cost time = " + (System.currentTimeMillis() - start) + "获取粉丝趋势总时间");
		
		return dto;
	}

	
	
	void saveFansCumulate(String authorizerAppId, FansSCDto dto) throws ParseException{
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		Date now = new Date();
		
		OrgWechatFansCumulate fansCumulate = new OrgWechatFansCumulate();
		fansCumulate.setAuthorizerAppId( authorizerAppId );
		fansCumulate.setNewUser( dto.getYtNewFans() );
		fansCumulate.setCancelUser( dto.getYtCancelFans() );
		fansCumulate.setCumulateUser( dto.getYtCumulateFans() );
		fansCumulate.setRefDate( sdf.parse(dto.getYtDate()) );
		fansCumulate.setCreateTime( now );
		try{
			fansCumulateDao.save(fansCumulate,true);
		}catch(Exception e){
			log.warn("wechat - StatisticsServiceImpl - getFansStatistics - fansCumulateDao.save error",e);
		}
	}
}

