/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import lombok.extern.slf4j.Slf4j;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoCallbackHandler;
import com.baijia.tianxiao.sal.wechat.api.ReleaseTest;
import com.baijia.tianxiao.sal.wechat.constant.wechatmsg.WechatMsgType;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.WechatAbstractMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.event.WechatEventMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatOrdinaryMessage;
import com.baijia.tianxiao.sal.wechat.dto.wechatmsg.ordinary.WechatTextMessage;
import com.baijia.tianxiao.sal.wechat.dto.request.AuthorizationInfoCallbackRequest;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.autoreply.PassiveReplyMsgBuilder;
import com.baijia.tianxiao.sal.wechat.helper.sendmsg.customer.CustomerServiceApiHelper;


/**   
 * @Title       : ReleaseTestImpl 
 * @Description : 
 * @Author      : zhenyujian
 * @Date        : 2015年12月3日 下午4:18:46 
 */
@Slf4j
@Service
public class ReleaseTestImpl implements ReleaseTest {


    private static final String RELEASE_TEST_APP_ID = "wx570bc396a51b8ff8"; // 全网检测专用公众号appid

    
    @Autowired
    private AuthorizationInfoCallbackHandler handler;
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    
    
    
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void setAuthCode(String authCode, Integer expiresIn) {
        String orgNum = WechatProperties.getKeyOpenAuthCodeCallBackTestNum();
        OrgAccount account = orgAccountDao.getAccountByNumber(Integer.parseInt(orgNum));
        if (account == null) {
            throw new IllegalArgumentException("account is null, orgNum: " + orgNum);
        }
        
        AuthorizationInfoCallbackRequest cbRequest = new AuthorizationInfoCallbackRequest();
        cbRequest.setOrgId(account.getId());
        cbRequest.setAuthCode(authCode);
        cbRequest.setExpiresIn(expiresIn);
        handler.handleTest(cbRequest);
    }

    
    
    @Transactional(rollbackFor = Exception.class)
    @Override
    public String handleTestMsg(WechatAbstractMessage message) {
        try {
            String content = "";
            if (message.getMsgType() == WechatMsgType.EVENT) {
                content = getEventResponse((WechatEventMessage) message);
            } else {
                content = getOrdinaryResponse((WechatOrdinaryMessage) message);
            }

            String response =
            //    WechatCryptUtils.encryptMsg(message.getFromUserName(), message.getToUserName(), "text", content);
            
            PassiveReplyMsgBuilder.textMsg(message.getToUserName(), message.getFromUserName(), content);
            
            return response;
        } catch (Exception e) {
        	e.printStackTrace();
        	log.error(e.toString());
            throw e;
        }
    }

    private String getOrdinaryResponse(WechatOrdinaryMessage message) {
        if (message.getMsgType() == WechatMsgType.TEXT) {
            return getTextResponse((WechatTextMessage) message);
        }
        return "";
    }

    private String getTextResponse(WechatTextMessage message) {
        String content = message.getContent();

        if (content.indexOf("TESTCOMPONENT_MSG_TYPE_TEXT") >= 0) {
            return getImmediateMessageResponse(message);
        }

        final String QUERY_AUTH_CODE = "QUERY_AUTH_CODE:";
        int idx = content.indexOf(QUERY_AUTH_CODE);
        if (idx >= 0) {
            String authCode = message.getContent().substring(idx + QUERY_AUTH_CODE.length());
            return getCustomerMessageResponse(authCode, message);
        }
        return "";
    }

    private String getEventResponse(WechatEventMessage message) {
        return message.getEvent() + "from_callback";
    }

    private String getImmediateMessageResponse(WechatTextMessage message) {
        // 立即回复
        return message.getContent() + "_callback";
    }

    private String getCustomerMessageResponse(String authCode, WechatTextMessage message) {
        setAuthCode(authCode, 600);

        // 立即回复空串, 同时调用客服接口回复正文
        callTestCustomer(RELEASE_TEST_APP_ID, message.getFromUserName(), authCode);
        return "";
    }

    private void callTestCustomer(String appId, String toUser, String authCode) {
        AuthorizationInfo info = authorizationInfoDao.getByAuthorizerAppId(appId);
        CustomerServiceApiHelper.sendTextMsg(info.getAuthorizerAccessToken(), toUser, authCode + "_from_api");
    }

}
