/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper.sendmsg.customer;

import lombok.extern.slf4j.Slf4j;

import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.constant.SalWechatErrorCode;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;

/**   
 * @Title       : OpenPlatformApiCaller 
 * @Description : 微信公众平台 发送消息 - 客服相关接口
 * @Author      : zhenyujian
 * @Date        : 2015年12月3日 上午11:01:58 
 */
@Slf4j
public class CustomerServiceApiHelper {
	
	public static WechatApiResponse sendTextMsg(String accessToken, String toOpenId, String content) throws WechatException, WebServiceException{
		log.info("wechat - CustomerServiceApiHelper - sendTextMsg");
		try{
			return CustomerServiceApiCaller.sendTextMsg(accessToken, toOpenId, content);
		}catch(WechatException e){
			if(e.getErrorCode() == SalWechatErrorCode.WECHAT_ILLEGAL_OPENID){
				throw new WechatException(SalWechatErrorCode.WECHAT_SEND_MESSAGE_FAIL);
			}else{
				throw e;
			}
		}
	}
	
	public static WechatApiResponse sendImageMsg(String accessToken, String toOpenId, String mediaId) throws WechatException, WebServiceException{
		log.info("wechat - CustomerServiceApiHelper - sendImageMsg");
		try{
			return CustomerServiceApiCaller.sendImageMsg(accessToken, toOpenId, mediaId);
		}catch(WechatException e){
			if(e.getErrorCode() == SalWechatErrorCode.WECHAT_ILLEGAL_OPENID){
				throw new WechatException(SalWechatErrorCode.WECHAT_SEND_MESSAGE_FAIL);
			}else{
				throw e;
			}
		}
	}
	
	public static WechatApiResponse sendVoiceMsg(String accessToken, String toOpenId, String mediaId) throws WechatException, WebServiceException{
		log.info("wechat - CustomerServiceApiHelper - sendVoiceMsg");
		try{
			return CustomerServiceApiCaller.sendVoiceMsg(accessToken, toOpenId, mediaId);
		}catch(WechatException e){
			if(e.getErrorCode() == SalWechatErrorCode.WECHAT_ILLEGAL_OPENID){
				throw new WechatException(SalWechatErrorCode.WECHAT_SEND_MESSAGE_FAIL);
			}else{
				throw e;
			}
		}
	}
	
}

