/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.dto.msgfromapp;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

import lombok.Data;

/**   
 * @title       : MessagePushDto 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2015年12月5日 下午1:53:09 
 */
@Data
public class MessageDto {

	private Integer msgT;
	private Integer msgId;
	private Long time;
	private Integer orgId;
	private Long consultUserId;
	private MessageContentDto content;
	
	private String wechatAppid;//机构绑定的微信号的appId
	private String wechatOpenId;//微信open id
	
	public MessageDto(){
	}
	
	public MessageDto(Integer msgT, Integer msgId, Long time, Integer orgId, Long consultUserId){
		this.msgT = msgT;
		this.msgId = msgId;
		this.time = time;
		this.orgId = orgId;
	}
	
	public void setTextContent(String text){
		this.setContent( MessageContentDto.buildTextContent(text) );
	}

	public void setVoiceContent(Integer storageId, String url, Integer length){
		this.setContent( MessageContentDto.buildVoiceContent(storageId, url, length) );
	}
	
	public void setImageContent(Integer storageId, String url, Integer height, Integer width){
		this.setContent( MessageContentDto.buildImageContent(storageId, url, height, width));
	}
	
	
	@Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }
    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

