/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.dto.msgfromapp;

import lombok.Data;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

/**   
 * @title       : MessagePushContentDto 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2015年12月5日 下午1:53:13 
 */
@Data
public class MessageContentDto {
	private String text;
	private Integer storageId;
	private String url;
	private Integer width;
	private Integer height;
	private Integer length;
	
	public MessageContentDto(){
	}
	
	static MessageContentDto buildTextContent(String text){
		MessageContentDto dto = new MessageContentDto();
		dto.setText(text);
		return dto;
	}
	
	static MessageContentDto buildVoiceContent(Integer storageId, String url, Integer length){
		MessageContentDto dto = new MessageContentDto();
		dto.setStorageId(storageId);
		dto.setUrl(url);
		dto.setLength(length);
		return dto;
	}

	static MessageContentDto buildImageContent(Integer storageId, String url, Integer height, Integer width){
		MessageContentDto dto = new MessageContentDto();
		dto.setStorageId(storageId);
		dto.setUrl(url);
		dto.setHeight(height);
		dto.setWidth(width);
		return dto;
	}
	
	
	
	@Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }
    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

