/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.task;

import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.api.FansService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FansSyncJob
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(FansSyncJob.class);
    private FansService fansService;
    private String authorizerAppId;

    public FansSyncJob(FansService fansService, String authorizerAppId) {
        this.fansService = fansService;
        this.authorizerAppId = authorizerAppId;
    }

    @Override
    public void run() {
        log.info("Wechat - FansSyncJob - run - start - authorizerAppId:{}", (Object)this.authorizerAppId);
        int amount = 0;
        try {
            Thread.currentThread();
            Thread.sleep(5000L);
            amount = this.fansService.syncFansIncrement(this.authorizerAppId);
        }
        catch (WechatException e) {
            log.error("Wechat - FansSyncJob - WechatException - e:{}", (Throwable)e);
        }
        catch (Exception e) {
            log.error("Wechat - FansSyncJob - Exception - e:{}", (Throwable)e);
        }
        if (amount > 0) {
            try {
                Thread.currentThread();
                Thread.sleep(5000L);
                this.fansService.batchConvertFansHeadImg(this.authorizerAppId);
            }
            catch (Exception e) {
                log.error("Wechat - batchConvertFansHeadImg - Exception - e:{}", (Throwable)e);
            }
        }
    }
}

