/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.dal.commons.UnifiedWechatAccountConfigDto;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgBranchsDao;
import com.baijia.tianxiao.dal.org.dao.OrgStorageDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgBranchs;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStorage;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.wechat.constant.WechatAppServiceType;
import com.baijia.tianxiao.dal.wechat.constant.WechatStatusEnum;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.UnifiedWechatAccountDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.UnifiedWechatAccount;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.smstoken.StudentSmsTokenDto;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.OrgErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.common.api.OrganizationInfoAPIService;
import com.baijia.tianxiao.sal.common.utils.OrgInfoCampare;
import com.baijia.tianxiao.sal.wechat.api.CustomMenuService;
import com.baijia.tianxiao.sal.wechat.api.UnifiedWechatAccountService;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.dto.unifiedWechatAccount.CampusInfoDto;
import com.baijia.tianxiao.sal.wechat.dto.unifiedWechatAccount.CampusWechatInfoDto;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;
import com.baijia.tianxiao.util.Distance;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class UnifiedWechatAccountServiceImpl
implements UnifiedWechatAccountService {
    private static final Logger log = LoggerFactory.getLogger(UnifiedWechatAccountServiceImpl.class);
    @Autowired
    private UnifiedWechatAccountDao unifiedWechatAccountDao;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private OrgSubAccountDao orgSubAccountDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private CustomMenuService customMenuService;
    @Autowired
    private OrganizationInfoAPIService organizationInfoAPIService;
    @Autowired
    private OrgBranchsDao orgBranchsDao;
    @Autowired
    private OrgStorageDao orgStorageDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgTeacherDao orgTeacherDao;

    @Override
    public UnifiedWechatAccount addUnifiedWechatAccount(Long orgId, Long masterOrgId) {
        AuthorizerInfo slaveCampusAccount;
        OrgAccount orgAccount = this.organizationInfoAPIService.findOrgAccountWithOrgId(orgId);
        if (orgAccount == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.NOT_FOUND, "can not find any organization with orgId :" + orgId);
        }
        AuthorizerInfo masterWechatAccount = this.authorizerInfoDao.getByOrgId(Integer.valueOf(masterOrgId.intValue()));
        log.info("master authorizerInfo is :{} ", (Object)masterWechatAccount);
        boolean masterHasBound = true;
        if (masterWechatAccount == null) {
            masterHasBound = false;
            log.info("master organization:{} has not bind a wechat account , but want to add a slave campus {}  as a unifiedWechatAccount ", (Object)masterOrgId, (Object)orgId);
        }
        if ((slaveCampusAccount = this.authorizerInfoDao.getByOrgId(Integer.valueOf(orgId.intValue()), false)) != null) {
            throw new BussinessException((UniverseErrorCode)OrgErrorCode.ORG_STILL_BIND_WECHAT);
        }
        UnifiedWechatAccount subCampusRecord = this.unifiedWechatAccountDao.findUnifiedWechatRecord(orgId, true, null);
        log.info("subCampusRecord is :{} ", (Object)subCampusRecord);
        if (subCampusRecord != null) {
            if (subCampusRecord.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue()) {
                log.info("subCampusRecord has already init :{}", (Object)subCampusRecord);
                return subCampusRecord;
            }
            subCampusRecord.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
            subCampusRecord.setUpdateTime(new Date());
        }
        log.info("need init master  ");
        this.initMasterAccount(masterOrgId, masterWechatAccount, masterHasBound);
        Integer orgNumber = orgAccount.getNumber();
        subCampusRecord = subCampusRecord == null ? UnifiedWechatAccount.newInstance((Long)orgId, (Long)orgNumber.longValue(), (Integer)masterOrgId.intValue()) : subCampusRecord;
        subCampusRecord.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        this.unifiedWechatAccountDao.saveOrUpdate((Object)subCampusRecord, new String[0]);
        return subCampusRecord;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void initMasterAccount(Long masterOrgId, AuthorizerInfo masterWechatAccount, boolean masterHasBound) {
        OrgAccount orgAccount = this.organizationInfoAPIService.findOrgAccountWithOrgId(masterOrgId);
        if (orgAccount == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.NOT_FOUND, "can not find any organization with orgId :" + masterOrgId);
        }
        boolean needInit = masterHasBound;
        log.info("masterUnifiedWechatAccount is need init ? {} ", (Object)needInit);
        UnifiedWechatAccount masterRecord = this.unifiedWechatAccountDao.findUnifiedWechatRecord(masterOrgId, true, null);
        if (masterRecord == null) {
            masterRecord = UnifiedWechatAccount.newInstance((Long)masterOrgId, (Long)orgAccount.getNumber().longValue(), (Integer)masterOrgId.intValue());
            masterRecord.setMasterOrgId(Integer.valueOf(0));
        } else if (masterRecord.getDelStatus().intValue() == DeleteStatus.NORMAL.getValue() && masterRecord.isInitOver()) {
            log.info("need not init master account :{} ", (Object)masterRecord);
            return;
        }
        if (masterHasBound) {
            masterRecord.setInitStatus(UnifiedWechatAccount.IS_INIT_OVER);
        }
        masterRecord.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        try {
            this.unifiedWechatAccountDao.saveOrUpdate((Object)masterRecord, new String[0]);
        }
        catch (Exception e) {
            GenericsUtils.logErrorAndInfo(this.getClass(), (Exception)e, (String)"can not saveOrUpdate unifiedWechatAccount:{} ", (Object[])new Object[]{masterRecord});
        }
        log.info("init unifiedWechatAccount master over :{} ", (Object)masterRecord);
        if (needInit) {
            this.initMasterAccount(masterWechatAccount);
        }
    }

    @Override
    public List<UnifiedWechatAccountConfigDto> orgCampusUnifiedWechatAccountStatus(Long masterOrgId) {
        ArrayList<UnifiedWechatAccountConfigDto> status = null;
        List orgSubaccounts = this.orgSubAccountDao.getSlavesByMasterOrgId(Integer.valueOf(masterOrgId.intValue()), null);
        if (GenericsUtils.isNullOrEmpty((Object)orgSubaccounts)) {
            return GenericsUtils.emptyList();
        }
        status = new ArrayList<UnifiedWechatAccountConfigDto>(orgSubaccounts.size());
        Map map = CollectionUtils.extractMap((Collection)orgSubaccounts, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, OrgSubAccount>(){

            public Long extract(OrgSubAccount arg0) {
                return arg0.getOrgId().longValue();
            }
        });
        Map getorgNumbersByOrgIds = this.orgAccountDao.getorgNumbersByOrgIds(map.keySet());
        List findUnifiedWechatRecords = this.unifiedWechatAccountDao.findUnifiedWechatRecords(map.keySet(), true, Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        for (UnifiedWechatAccount uwa : findUnifiedWechatRecords) {
            Long orgId = uwa.getOrgId();
            if (map.get(orgId) == null) continue;
            status.add(UnifiedWechatAccountConfigDto.newInstance((Long)((Integer)getorgNumbersByOrgIds.get(orgId)).longValue(), (Integer)1));
            map.remove(orgId);
        }
        for (Long orgId : map.keySet()) {
            status.add(UnifiedWechatAccountConfigDto.newInstance((Long)((Integer)getorgNumbersByOrgIds.get(orgId)).longValue(), (Integer)0));
        }
        log.info("find all campus's status are :{} for masterOrgId:{} ", status, (Object)masterOrgId);
        return status;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public void initMasterAccount(AuthorizerInfo masterWechatAccount) {
        String quickMenuJson = this.customMenuService.getQuickMenuJson(masterWechatAccount.getOrgId());
        this.customMenuService.updateOrgWechatMenu(masterWechatAccount, quickMenuJson, true);
    }

    @Override
    public String createCampusListUrl(Integer orgNumber, String appId) {
        return this.customMenuService.createCampusListUrl(orgNumber, appId);
    }

    @Override
    public List<CampusInfoDto> listAllCampusUseUnifiedAccount(Long orgNumber, String openId) {
        OrgAccount orgAccount = this.orgAccountDao.getAccountByNumber(Integer.valueOf(orgNumber.intValue()), new String[0]);
        if (orgAccount == null) {
            return GenericsUtils.emptyList();
        }
        ArrayList campusInfoDtos = Lists.newArrayList();
        HashMap orgInfoMap = Maps.newHashMap();
        HashMap orgNumberMapper = Maps.newHashMap();
        Integer orgId = orgAccount.getId();
        AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(orgId);
        this.fillAllCampusOrgInfo(orgInfoMap, orgNumberMapper, orgId);
        if (GenericsUtils.isNullOrEmpty((Object)orgInfoMap)) {
            orgInfoMap.put(orgId, this.organizationInfoAPIService.getOrgInfoMap(Arrays.asList(orgId)).get(orgId));
            orgNumberMapper.put(orgId, orgAccount.getNumber());
        }
        ArrayList orgInfos = new ArrayList(orgInfoMap.values());
        Collections.sort(orgInfos, new Comparator<OrgInfo>(){

            @Override
            public int compare(OrgInfo o1, OrgInfo o2) {
                return UnifiedWechatAccountServiceImpl.this.compareUsePinyin(o1, o2);
            }
        });
        for (OrgInfo orgInfo : orgInfos) {
            Integer orgId_ = orgInfo.getOrgId();
            Integer number = (Integer)orgNumberMapper.get(orgId_);
            String orgName = orgInfo.getShortName();
            Double latitude = orgInfo.getLatitude();
            Double longitude = orgInfo.getLongitude();
            String chatUrl = "";
            if (authorizerInfo != null) {
                chatUrl = this.createChatUrl(authorizerInfo.getAuthorizerAppId(), orgId_, number, openId);
            }
            CampusInfoDto campusInfoDto = CampusInfoDto.newInstance(orgName, number, null, null, null, latitude, longitude, null, chatUrl);
            this.appendOrgInfo(orgInfo, number, campusInfoDto);
            campusInfoDtos.add(campusInfoDto);
        }
        return campusInfoDtos;
    }

    protected int compareUsePinyin(OrgInfo o1, OrgInfo o2) {
        return OrgInfoCampare.compareUsePinyin((String)o1.getShortName(), (String)o2.getShortName());
    }

    private void fillAllCampusOrgInfo(Map<Integer, OrgInfo> orgInfoMap, Map<Integer, Integer> orgNumberMapper, Integer orgId) {
        if (orgId == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "invalid orgId :" + orgId);
        }
        List findUnifiedWechatRecords = this.unifiedWechatAccountDao.listAllCampusWithAnyOneOrgInfo(Long.valueOf(orgId.longValue()), true);
        List orgIds = GenericsUtils.toFieldList((Collection)findUnifiedWechatRecords, (String)"orgId");
        log.info("orgIds is :{} ", (Object)orgIds);
        orgInfoMap.putAll(this.organizationInfoAPIService.getOrgInfoMap(orgIds));
        List allOrgAccounts = this.orgAccountDao.getByIds(orgInfoMap.keySet(), new String[]{"id", "number"});
        orgNumberMapper.putAll(GenericsUtils.toFieldMap((Collection)allOrgAccounts, (String[])new String[]{"id", "number"}));
    }

    @Override
    public Map<String, String> listAllCampusCoursesUrl(Long orgNumber) {
        OrgAccount orgAccount = this.organizationInfoAPIService.findOrgAccountWithOrgNumber(orgNumber);
        if (orgAccount == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.NOT_FOUND, String.format("can not find any orgAccount with orgNumber:%s", orgNumber));
        }
        LinkedHashMap orgNameAndCourseUrlMapper = Maps.newLinkedHashMap();
        Integer orgId = orgAccount.getId();
        HashMap orgInfoMap = Maps.newHashMap();
        HashMap orgNumberMapper = Maps.newHashMap();
        this.fillAllCampusOrgInfo(orgInfoMap, orgNumberMapper, orgId);
        log.info("all orgInfo are :{} ", orgInfoMap.values());
        ArrayList orgInfos = new ArrayList(orgInfoMap.values());
        Collections.sort(orgInfos, new Comparator<OrgInfo>(){

            @Override
            public int compare(OrgInfo o1, OrgInfo o2) {
                return UnifiedWechatAccountServiceImpl.this.compareUsePinyin(o1, o2);
            }
        });
        log.info("keySorted are :{} ", orgInfos);
        for (OrgInfo orgInfo : orgInfos) {
            String orgName = orgInfo.getShortName();
            String courseUrl = this.getCourseUrl((Integer)orgNumberMapper.get(orgInfo.getOrgId()));
            orgNameAndCourseUrlMapper.put(orgName, courseUrl);
        }
        return orgNameAndCourseUrlMapper;
    }

    private String getCourseUrl(Integer orgNumber) {
        String fmt2 = "%s%s%s";
        return String.format(fmt2, WechatProperties.getWebMTianXiaoUrlPrefix(), "course/", orgNumber);
    }

    @Override
    public String createChatUrl(String appId, Integer orgId, Integer number, String openId) {
        if (GenericsUtils.isNullOrEmpty((Object)openId)) {
            return "";
        }
        StudentSmsTokenDto token = new StudentSmsTokenDto(Long.valueOf(orgId.longValue()), appId, null, openId);
        String imSite = null;
        try {
            imSite = WechatWebAuthLinkBuilder.imSite(WebAuthScope.BASE, appId, token.toTokenStr());
        }
        catch (Exception e) {
            GenericsUtils.logErrorAndInfo((Logger)log, (Exception)e, (String)"can not crate chat url for openId :{} with orgId:{} ", (Object[])new Object[]{openId, orgId});
        }
        return imSite;
    }

    public void appendOrgInfo(OrgInfo orgInfo, Integer number, CampusInfoDto campusInfoDto) {
        try {
            Integer orgId = orgInfo.getOrgId();
            String _400_phone = orgInfo.getExtension();
            campusInfoDto.setMobile(GenericsUtils.isNullOrEmpty((Object)_400_phone) ? _400_phone : "4000122166," + _400_phone);
            List branchsList = this.orgBranchsDao.listBranchsByOrgId(orgId.intValue());
            String address = "";
            if (GenericsUtils.notNullAndEmpty((Object)branchsList)) {
                OrgBranchs branchs = (OrgBranchs)branchsList.get(0);
                address = this.buildAddress(branchs.getProvince(), branchs.getCounty(), branchs.getDistrict(), branchs.getAddress(), branchs.getBranchName());
            }
            campusInfoDto.setAddress(address);
            campusInfoDto.setMUrl(this.getMUrl(number));
            String lhost = PropertiesReader.getValue((String)"wxm", (String)"m.server");
            if (lhost != null && lhost.startsWith("https:")) {
                lhost = lhost.replace("https", "http");
            }
            campusInfoDto.setLocationUrl(lhost + "/branch/" + number);
        }
        catch (Exception e) {
            log.warn("[OrgInfo] Exception and orgInfo : {} and campusInfoDto is :{} ", new Object[]{e.getMessage(), orgInfo, campusInfoDto});
        }
    }

    private String buildAddress(String ... strs) {
        if (GenericsUtils.isNullOrEmpty((Object)strs)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String str : strs) {
            if (!GenericsUtils.notNullAndEmpty((Object)str)) continue;
            sb.append(str);
        }
        return sb.toString();
    }

    @Override
    public CampusInfoDto findCloseOrgInfo(Long orgNumber, double longitude, double latitude) {
        OrgAccount orgAccount = this.organizationInfoAPIService.findOrgAccountWithOrgNumber(orgNumber);
        if (orgAccount == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "invalid orgNumber : " + orgNumber);
        }
        HashMap orgNumberMapper = Maps.newHashMap();
        HashMap orgInfoMap = Maps.newHashMap();
        this.fillAllCampusOrgInfo(orgInfoMap, orgNumberMapper, orgAccount.getId());
        Map<Integer, OrgBranchs> orgBranchsMapper = this.queryBranchs(orgNumberMapper.keySet());
        CampusInfoDto campusInfoDto = null;
        OrgInfo mostlyCloseOrgInfo = null;
        double minDistance = Double.MAX_VALUE;
        for (Map.Entry entry : orgInfoMap.entrySet()) {
            OrgInfo orgInfo = (OrgInfo)entry.getValue();
            OrgBranchs orgBranchs = orgBranchsMapper.get(orgInfo.getOrgId());
            if (orgBranchs == null) continue;
            try {
                double getDistance = Distance.GetDistance((double)longitude, (double)latitude, (double)((Double)GenericsUtils.getNumValueFromStr(Double.class, (String)orgBranchs.getLongitude())), (double)((Double)GenericsUtils.getNumValueFromStr(Double.class, (String)orgBranchs.getLatitude())));
                if (!(getDistance < minDistance)) continue;
                minDistance = getDistance;
                mostlyCloseOrgInfo = orgInfo;
            }
            catch (Exception e) {
                GenericsUtils.logErrorAndInfo((Logger)log, (Exception)e, (String)"can not compare for : {} and current mostlyCloseOrgInfo is :{} , minDistance is :{} ", (Object[])new Object[]{orgBranchs, mostlyCloseOrgInfo, minDistance});
            }
        }
        if (mostlyCloseOrgInfo != null) {
            Integer number = (Integer)orgNumberMapper.get(mostlyCloseOrgInfo.getOrgId());
            String mUrl = this.getMUrl(number);
            campusInfoDto = CampusInfoDto.newInstance(mostlyCloseOrgInfo.getName(), number, "", mUrl, "", null, null, "", "");
        } else {
            log.info("Positioning failure, jump to the master account by default ,orgNumber:{} ,and longitude:{} ,latitude:{}", new Object[]{orgNumber, longitude, latitude});
            campusInfoDto = CampusInfoDto.newInstance("", orgNumber.intValue(), "", this.getMUrl(orgNumber.intValue()), "", null, null, "", "");
        }
        return campusInfoDto;
    }

    private Map<Integer, OrgBranchs> queryBranchs(Set<Integer> orgIds) {
        List branchsList = this.orgBranchsDao.listBranchsByOrgIds(orgIds);
        HashMap orgBranchsMapper = Maps.newHashMap();
        for (OrgBranchs ob : branchsList) {
            if (orgBranchsMapper.get(ob.getOrgId()) != null) continue;
            orgBranchsMapper.put(ob.getOrgId(), ob);
        }
        return orgBranchsMapper;
    }

    private String getMUrl(Integer number) {
        String mhost = PropertiesReader.getValue((String)"wxm", (String)"m.server");
        String mUrl = mhost + "/i/" + number;
        return mUrl;
    }

    @Override
    public Map<Integer, CampusWechatInfoDto> findCampusWechatStatus(Collection<Integer> orgIds, Integer masterOrgId) {
        log.info("orgIds is :{} ", orgIds);
        if (GenericsUtils.isNullOrEmpty(orgIds)) {
            return GenericsUtils.emptyMap();
        }
        HashMap campusWechatInfoDtos = Maps.newHashMap();
        if (!orgIds.contains(masterOrgId)) {
            orgIds.add(masterOrgId);
        }
        HashSet orgIdsInLong = Sets.newHashSet();
        for (Integer orgId : orgIds) {
            orgIdsInLong.add(orgId.longValue());
        }
        List authorizerInfosByOrgIds = this.authorizerInfoDao.getAuthorizerInfosByOrgIds((Collection)orgIdsInLong);
        List findUnifiedWechatRecords = this.unifiedWechatAccountDao.findUnifiedWechatRecords((Collection)orgIdsInLong, true, Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        Map orgAuthorizerInfoMapper = GenericsUtils.toFieldMap((Collection)authorizerInfosByOrgIds, (String[])new String[]{"orgId"});
        Map orgUnifiedWechatAccountMapper = GenericsUtils.toFieldMap((Collection)findUnifiedWechatRecords, (String[])new String[]{"orgId"});
        AuthorizerInfo masterWechatAccount = (AuthorizerInfo)orgAuthorizerInfoMapper.get(masterOrgId);
        log.info("masterWechatAccount is :{} ", (Object)masterWechatAccount);
        for (Integer orgId : orgIds) {
            AuthorizerInfo ai = (AuthorizerInfo)orgAuthorizerInfoMapper.get(orgId);
            boolean isMaster = orgId.intValue() == masterOrgId.intValue();
            UnifiedWechatAccount uw = (UnifiedWechatAccount)orgUnifiedWechatAccountMapper.get(orgId.longValue());
            CampusWechatInfoDto campusWechatInfoDto = this.buildCampusWechatInfoDto(ai, uw, masterWechatAccount, isMaster);
            log.info("orgId:{} and ai :{} ,uw is :{} , and masterWechatAccount:{}", new Object[]{orgId, ai, uw, masterWechatAccount});
            campusWechatInfoDtos.put(orgId, campusWechatInfoDto);
        }
        return campusWechatInfoDtos;
    }

    private CampusWechatInfoDto buildCampusWechatInfoDto(AuthorizerInfo ai, UnifiedWechatAccount uw, AuthorizerInfo masterWechatAccount, boolean isMaster) {
        CampusWechatInfoDto campusWechatInfoDto = new CampusWechatInfoDto();
        if (ai != null) {
            log.info("find is like ,ai:{} ,master:{} ", (Object)ai.getId(), (Object)masterWechatAccount);
            if (masterWechatAccount != null && ai.getId().intValue() == masterWechatAccount.getId().intValue()) {
                if (isMaster) {
                    campusWechatInfoDto.setWechatName(ai.getNickName());
                    campusWechatInfoDto.setWechatStatus(WechatStatusEnum.MASTER_BIND.status);
                    campusWechatInfoDto.setWechatStatusStr(WechatStatusEnum.MASTER_BIND.desc);
                    campusWechatInfoDto.setWechatUr(this.findAvatarUrl(ai.getQrcodeStorageId(), ai.getQrcodeUrl()));
                    campusWechatInfoDto.setOrgWehatType(this.findOrgWechatType(ai));
                } else {
                    campusWechatInfoDto.setWechatName(masterWechatAccount.getNickName());
                    campusWechatInfoDto.setWechatStatus(WechatStatusEnum.UNIFIED_ACCOUNT_WITH_MASTER.status);
                    campusWechatInfoDto.setWechatStatusStr(WechatStatusEnum.UNIFIED_ACCOUNT_WITH_MASTER.desc);
                    campusWechatInfoDto.setWechatUr(this.findAvatarUrl(masterWechatAccount.getQrcodeStorageId(), masterWechatAccount.getQrcodeUrl()));
                    campusWechatInfoDto.setOrgWehatType(this.findOrgWechatType(masterWechatAccount));
                }
            } else {
                campusWechatInfoDto.setWechatName(ai.getNickName());
                campusWechatInfoDto.setWechatStatus(WechatStatusEnum.INDEPENDENT.status);
                campusWechatInfoDto.setWechatStatusStr(WechatStatusEnum.INDEPENDENT.desc);
                campusWechatInfoDto.setWechatUr(this.findAvatarUrl(ai.getQrcodeStorageId(), ai.getQrcodeUrl()));
                campusWechatInfoDto.setOrgWehatType(this.findOrgWechatType(ai));
            }
        } else if (masterWechatAccount != null) {
            campusWechatInfoDto.setWechatName("");
            campusWechatInfoDto.setWechatStatus(WechatStatusEnum.INDEPENDENT_UN_BIND.status);
            campusWechatInfoDto.setWechatStatusStr(WechatStatusEnum.INDEPENDENT_UN_BIND.desc);
            campusWechatInfoDto.setWechatUr("");
        } else if (uw != null) {
            campusWechatInfoDto.setWechatName("");
            campusWechatInfoDto.setWechatStatus(WechatStatusEnum.UNIFIED_ACCOUNT_WITH_MASTER_UN_BIND.status);
            campusWechatInfoDto.setWechatStatusStr(WechatStatusEnum.UNIFIED_ACCOUNT_WITH_MASTER_UN_BIND.desc);
            campusWechatInfoDto.setWechatUr("");
        } else if (isMaster) {
            campusWechatInfoDto.setWechatName("");
            campusWechatInfoDto.setWechatStatus(WechatStatusEnum.MASTER_UN_BIND.status);
            campusWechatInfoDto.setWechatStatusStr(WechatStatusEnum.MASTER_UN_BIND.desc);
            campusWechatInfoDto.setWechatUr("");
        } else {
            campusWechatInfoDto.setWechatName("");
            campusWechatInfoDto.setWechatStatus(WechatStatusEnum.INDEPENDENT_UN_BIND.status);
            campusWechatInfoDto.setWechatStatusStr(WechatStatusEnum.INDEPENDENT_UN_BIND.desc);
        }
        return campusWechatInfoDto;
    }

    private String findOrgWechatType(AuthorizerInfo ai) {
        String serviceType = WechatAppServiceType.getNote((Integer)ai.getServiceType());
        serviceType = WechatAppServiceType.SUBSCRIBE_APP_FROM_OLD.getValue() == ai.getServiceType().intValue() ? "\u8ba2\u9605\u53f7" : serviceType;
        String verifyType = ai.getVerifyType() == -1 ? "\u672a\u8ba4\u8bc1" : "\u8ba4\u8bc1";
        return verifyType + " " + serviceType;
    }

    private String findAvatarUrl(Integer qrcodeStorageId, String defaultValue) {
        String avatarUrl = null;
        OrgStorage storage = (OrgStorage)this.orgStorageDao.getById((Serializable)Long.valueOf(qrcodeStorageId.longValue()), new String[0]);
        log.info("storage id is : {} and storage is :{} ", (Object)qrcodeStorageId.longValue(), (Object)storage);
        avatarUrl = storage != null ? StorageUtil.constructUrl((String)storage.getFid(), (String)storage.getSn(), (Integer)storage.getMimeType()) : defaultValue;
        return avatarUrl;
    }

    @Override
    public void clearUnifiedWechatAccountRecord(Long masterOrgId) {
        this.unifiedWechatAccountDao.deleteByOrgId(masterOrgId);
    }

    @Override
    public UnifiedWechatAccount findUnifiedWechatAccountWithOrgId(Integer orgId) {
        return this.unifiedWechatAccountDao.findUnifiedWechatRecord(Long.valueOf(orgId.longValue()), true, Integer.valueOf(DeleteStatus.NORMAL.getValue()));
    }

    @Override
    public UnifiedWechatAccount findMasterAccountWithAnyCampusOrgId(Integer orgId, Boolean isInit) {
        return this.unifiedWechatAccountDao.findMasterAccountWithAnyCampusOrgId(orgId, isInit);
    }

    public CampusInfoDto singleCampusInfoDto(OrgAccount findOrgAccountWithOrgNumber) {
        Integer orgId = findOrgAccountWithOrgNumber.getId();
        Map orgInfoMap = this.organizationInfoAPIService.getOrgInfoMap(Arrays.asList(orgId));
        CampusInfoDto cif = null;
        if (GenericsUtils.notNullAndEmpty((Object)orgInfoMap)) {
            OrgInfo orgInfo = (OrgInfo)orgInfoMap.get(orgId);
            String name = orgInfo.getShortName();
            cif = new CampusInfoDto();
            cif.setOrgName(name);
            cif.setOrgNumber(findOrgAccountWithOrgNumber.getNumber());
            cif.setOrgNumber(findOrgAccountWithOrgNumber.getNumber());
        }
        return cif;
    }

    @Override
    public void deleteSlaveCampus(Integer slaveOrgId, Integer masterOrgId) {
        this.unifiedWechatAccountDao.deleteSlaveCampusByOrgId(Long.valueOf(slaveOrgId.longValue()));
        this.resetOrgWechatTypeIfNecessary(masterOrgId);
    }

    private void resetOrgWechatTypeIfNecessary(Integer masterOrgId) {
        boolean ifNesetOrgWechatTypeIfNecessary = this.unifiedWechatAccountDao.resetOrgWechatTypeIfNecessary(masterOrgId);
        log.info("ifNesetOrgWechatTypeIfNecessary:{} for orgId :{} ", (Object)ifNesetOrgWechatTypeIfNecessary, (Object)masterOrgId);
        try {
            if (ifNesetOrgWechatTypeIfNecessary) {
                AuthorizerInfo authorizerInfo = this.authorizerInfoDao.getByOrgId(masterOrgId);
                if (authorizerInfo == null) {
                    log.info("can not find authorizerInfo for masterOrgId:{} ", (Object)masterOrgId);
                    return;
                }
                String quickMenuJson = this.customMenuService.getQuickMenuJson(masterOrgId);
                log.info("to prepare reset organization's customMenu to :{} ", (Object)quickMenuJson);
                this.customMenuService.updateOrgWechatMenu(authorizerInfo, quickMenuJson, false);
                log.info("reset over for orgId:{} ", (Object)masterOrgId);
            }
        }
        catch (BussinessException e) {
            log.info(" 1 can not reset cause by :{} ", (Object)e.getMessage());
        }
        catch (Exception ex) {
            log.info(" 2 can not reset cause by :{} ", ex.getCause());
        }
    }

    @Override
    public String findWeixinFromCampusOrgWithMobile(Long orgId, String mobile, boolean isStudent) {
        List listAllCampusWithAnyOneOrgInfo = this.unifiedWechatAccountDao.listAllCampusWithAnyOneOrgInfo(orgId, true);
        if (GenericsUtils.isNullOrEmpty((Object)listAllCampusWithAnyOneOrgInfo)) {
            return "";
        }
        List orgIds = GenericsUtils.toFieldList((Collection)listAllCampusWithAnyOneOrgInfo, (String)"orgId");
        String weixin = "";
        if (isStudent) {
            List studentsByMobileAndOrgIds = this.orgStudentDao.getStudentsByMobileAndOrgIds((Collection)orgIds, mobile, new String[]{"weixin"});
            log.info("find student are :{} ", (Object)studentsByMobileAndOrgIds);
            if (GenericsUtils.isNullOrEmpty((Object)studentsByMobileAndOrgIds)) {
                return "";
            }
            for (OrgStudent orgStudent : studentsByMobileAndOrgIds) {
                if (!GenericsUtils.notNullAndEmpty((Object)orgStudent.getWeixin())) continue;
                weixin = orgStudent.getWeixin();
                log.info("find weixin is :{} ", (Object)weixin);
                break;
            }
        } else {
            List getTeachersByMobileAndOrgIds = this.orgTeacherDao.getTeachersByMobileAndOrgIds(orgIds, mobile, new String[]{"weixin"});
            if (GenericsUtils.isNullOrEmpty((Object)getTeachersByMobileAndOrgIds)) {
                return "";
            }
            for (OrgTeacher orgTeacher : getTeachersByMobileAndOrgIds) {
                if (!GenericsUtils.notNullAndEmpty((Object)orgTeacher.getWeixin())) continue;
                weixin = orgTeacher.getWeixin();
                log.info("find weixin is :{} ", (Object)weixin);
                break;
            }
        }
        return weixin;
    }
}

