/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.dto.common;

import com.baijia.tianxiao.sal.wechat.util.ValidationUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WechatMessagePayload {
    private static final Logger log = LoggerFactory.getLogger(WechatMessagePayload.class);
    public static final Integer FROM_WECHAT = 0;
    public static final Integer FROM_IM = 1;
    private Integer lastChatOrgId;
    private Long lastChatTime = System.currentTimeMillis();
    private Integer fromType;
    public static final String payloadFormat = "{'lastChatOrgId':%s,'fromType':%s,'lastChatTime':%s}";

    public static String instanceJsonPayloadFromIM(Integer lastChatOrgId) {
        return String.format(payloadFormat, lastChatOrgId, FROM_IM, System.currentTimeMillis());
    }

    public static String instanceJsonPayloadFromWeChat(Integer lastChatOrgId) {
        return String.format(payloadFormat, lastChatOrgId, FROM_WECHAT, System.currentTimeMillis());
    }

    public static String instanceJsonPayload(Integer lastChatOrgId, Integer fromType) {
        return String.format(payloadFormat, lastChatOrgId, fromType, System.currentTimeMillis());
    }

    public static WechatMessagePayload createWechatMessagePayload(String jsonInfo) {
        try {
            jsonInfo = WechatMessagePayload.preCheck(jsonInfo);
            log.info("json is :{} ", (Object)jsonInfo);
            return (WechatMessagePayload)JSONObject.toBean((JSONObject)JSONObject.fromObject((Object)jsonInfo), WechatMessagePayload.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String preCheck(String jsonInfo) {
        log.info("jsonInfo is :{} ", (Object)jsonInfo);
        if (ValidationUtils.isNumber(jsonInfo)) {
            return WechatMessagePayload.instanceJsonPayloadFromIM((Integer)GenericsUtils.getNumValueFromStr(Integer.class, (String)jsonInfo));
        }
        return jsonInfo;
    }

    public static void main(String[] args) {
        System.out.println(WechatMessagePayload.preCheck("62789"));
        String jsonStr = WechatMessagePayload.instanceJsonPayload(1234, 2);
        System.out.print(jsonStr);
        WechatMessagePayload createWechatMessagePayload = WechatMessagePayload.createWechatMessagePayload(jsonStr);
        System.out.println(createWechatMessagePayload);
    }

    public static String getImMarkKey(String fromUserName) {
        return fromUserName + "_IM_LAST_CHAT";
    }

    public static String getKey(String fromUserName) {
        return fromUserName + "_LAST_CHAT";
    }

    public Integer getLastChatOrgId() {
        return this.lastChatOrgId;
    }

    public Long getLastChatTime() {
        return this.lastChatTime;
    }

    public Integer getFromType() {
        return this.fromType;
    }

    public void setLastChatOrgId(Integer lastChatOrgId) {
        this.lastChatOrgId = lastChatOrgId;
    }

    public void setLastChatTime(Long lastChatTime) {
        this.lastChatTime = lastChatTime;
    }

    public void setFromType(Integer fromType) {
        this.fromType = fromType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WechatMessagePayload)) {
            return false;
        }
        WechatMessagePayload other = (WechatMessagePayload)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$lastChatOrgId = this.getLastChatOrgId();
        Integer other$lastChatOrgId = other.getLastChatOrgId();
        if (this$lastChatOrgId == null ? other$lastChatOrgId != null : !((Object)this$lastChatOrgId).equals(other$lastChatOrgId)) {
            return false;
        }
        Long this$lastChatTime = this.getLastChatTime();
        Long other$lastChatTime = other.getLastChatTime();
        if (this$lastChatTime == null ? other$lastChatTime != null : !((Object)this$lastChatTime).equals(other$lastChatTime)) {
            return false;
        }
        Integer this$fromType = this.getFromType();
        Integer other$fromType = other.getFromType();
        return !(this$fromType == null ? other$fromType != null : !((Object)this$fromType).equals(other$fromType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WechatMessagePayload;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $lastChatOrgId = this.getLastChatOrgId();
        result = result * 59 + ($lastChatOrgId == null ? 43 : ((Object)$lastChatOrgId).hashCode());
        Long $lastChatTime = this.getLastChatTime();
        result = result * 59 + ($lastChatTime == null ? 43 : ((Object)$lastChatTime).hashCode());
        Integer $fromType = this.getFromType();
        result = result * 59 + ($fromType == null ? 43 : ((Object)$fromType).hashCode());
        return result;
    }

    public String toString() {
        return "WechatMessagePayload(lastChatOrgId=" + this.getLastChatOrgId() + ", lastChatTime=" + this.getLastChatTime() + ", fromType=" + this.getFromType() + ")";
    }
}

