
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.wechat.util;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.sal.wechat.constant.custommenu.WechatMenuJsonKey;
import com.baijia.tianxiao.sal.wechat.dto.menu.Button;
import com.baijia.tianxiao.sal.wechat.dto.menu.ClickButton;
import com.baijia.tianxiao.sal.wechat.dto.menu.ComplexButton;
import com.baijia.tianxiao.sal.wechat.dto.menu.MediaButton;
import com.baijia.tianxiao.sal.wechat.dto.menu.Menu;
import com.baijia.tianxiao.sal.wechat.dto.menu.ViewButton;
import com.baijia.tianxiao.sal.wechat.dto.menu.ViewLimitedButton;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;

import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Nov 23, 2016
 * @Desc this guy is too lazy, nothing left.
 */
@Slf4j
public class MenuUtils {

    public static Menu covertJsonToMenu(String menuJson) {
        log.info("menuJson is : {}", menuJson);
        Menu menu = new Menu();
        JSONObject jsonObj = JSONObject.fromObject(menuJson);
        JSONArray jsonArray = jsonObj.getJSONArray(WechatMenuJsonKey.BUTTON);
        Button[] createButtons = createButtons(jsonArray);
        menu.addButton(createButtons);
        log.info("convert menuJson :{} to menu instance :{} ", menuJson, menu);
        return menu;
    }

    /**
     * @param next
     * @return
     */
    private static Button createButton(JSONObject next) {
        String type = null;
        if (next.get("type") != null) {
            type = next.getString("type");
        }
        boolean hasSubButton = GenericsUtils.isNullOrEmpty(type);
        Button button = null;
        if (hasSubButton) {
            button = new ComplexButton();
            button.setName(next.getString("name"));
            ((ComplexButton) button).addSubButton(createButtons(next.getJSONArray("sub_button")));
        } else if ("view".equals(type)) {
            button = instanceButton(next.toString(), ViewButton.class);
        } else if ("click".equals(type)) {
            button = instanceButton(next.toString(), ClickButton.class);
        } else if ("view_limited".equals(type)) {
            button = instanceButton(next.toString(), ViewLimitedButton.class);
        } else if ("media_id".equals(type)) {
            button = instanceButton(next.toString(), MediaButton.class);
        } else {
            // 其它类型的进行补充
        }
        return button;
    }

    /**
     * @param string
     * @param clazz
     * @return
     */
    private static <T> T instanceButton(String json, Class<T> clazz) {
        Gson gson = new Gson();
        T fromJson = gson.fromJson(json, clazz);
        return fromJson;
    }

    /**
     * @param object
     * @return
     */
    private static Button[] createButtons(JSONArray jsonArray) {
        List<Button> buttons = Lists.newArrayList();
        @SuppressWarnings("unchecked")
        Iterator<JSONObject> iterator = jsonArray.iterator();
        while (iterator.hasNext()) {
            JSONObject next = iterator.next();
            Button button = createButton(next);
            buttons.add(button);
        }
        return buttons.toArray(new Button[buttons.size()]);
    }

    public static void compareAndSetCustomMenu(Menu needSetMenu, Menu customMenu) {
        log.info("needSetMenu is :{} ", needSetMenu);
        log.info("customMenu is :{} ", customMenu);
        List<Button> needSetButtons = needSetMenu.getButton();
        List<Button> customButtons = customMenu.getButton();
        customButtons = GenericsUtils.isNullOrEmpty(customButtons) ? Lists.<Button> newArrayList() : customButtons;
        if (GenericsUtils.isNullOrEmpty(customMenu.getButton())) {
            customMenu.setButton(customButtons);
        }
        // 记住当前默认设置的所有菜单项(一级菜单)
        Map<String, Button> needSetSuperButtons = Maps.newHashMap();
        // 记住所有可能需要替换的菜单项(二级菜单)
        Map<String, Button> buttonResult = Maps.newHashMap();
        for (int i = 0; i < needSetButtons.size(); i++) {
            Button buttonNeedSet = needSetButtons.get(i);
            needSetSuperButtons.put(buttonNeedSet.getName(), buttonNeedSet);
            for (Button button_ : customButtons) {
                resetForComplexButton(buttonNeedSet, button_, buttonResult);
            }
        }
        log.info("buttonResult is :{} ", buttonResult);
        // 记住当前用户自定义菜单项(一级菜单)
        Map<String, Button> customSuperButtons = Maps.newHashMap();
        for (int i = 0; i < customButtons.size(); i++) {
            Button customButton = customButtons.get(i);
            customSuperButtons.put(customButton.getName(), customButton);
            // 进行用户自定义菜单项的替换
            Button checkoutButton = resetCustomMenuFromMap(customButton, buttonResult);
            customButtons.set(i, checkoutButton);
        }
        // 对于缺失的一级菜单项进行补充(存在用户自定义的二级菜单项里面包含该添加的待设置的一级菜单项里面的子菜单项)
        for (Map.Entry<String, Button> entry : needSetSuperButtons.entrySet()) {
            String key = entry.getKey();
            if (customSuperButtons.get(key) == null && customSuperButtons.size() < 3) {
                customButtons.add(entry.getValue());
            }
        }
    }

    /**
     * @param customButton
     * @param buttonResult
     * @param map
     */
    private static Button resetCustomMenuFromMap(Button customButton, Map<String, Button> buttonResult) {
        if (customButton instanceof ComplexButton) {
            List<Button> sub_button = ((ComplexButton) customButton).getSub_button();
            int size = sub_button.size();
            for (int i = 0; i < size; i++) {
                Button button_ = sub_button.get(i);
                Button checkoutButton = resetCustomMenuFromMap(button_, buttonResult);
                sub_button.set(i, checkoutButton);
            }
            return customButton;
        }
        Button findNewButton = buttonResult.get(customButton.getName());
        if (findNewButton != null) {
            return findNewButton;
        } else {
            return customButton;
        }
    }

    /**
     * @param button
     * @param buttonMayNeedAddList
     * @param customButtons
     */
    private static void resetForComplexButton(Button button, Button customButton, Map<String, Button> buttonResult) {
        if (button instanceof ComplexButton) {
            for (Button button_ : ((ComplexButton) button).getSub_button()) {
                resetForComplexButton(button_, customButton, buttonResult);
            }
            return;
        }
        if (customButton instanceof ComplexButton) {
            for (Button button_ : ((ComplexButton) customButton).getSub_button()) {
                resetForComplexButton(button, button_, buttonResult);
            }
            return;
        }
        String name1 = button.getName();
        String name2 = customButton.getName();
        log.info("name1 is :{} and name2 is:{} ", name1, name2);
        if (name1.equals(name2)) {
            buttonResult.put(name1, button);
        }
    }

    /**
     * @param needSetButtons
     * @param customButtons
     */
    public void replaceWithNeedSet(List<Button> needSetButtons, List<Button> customButtons) {
        log.info("needSetButtons are : {} ", needSetButtons);
        log.info("customButtons are : {} ", customButtons);

        for (int i = 0; i < needSetButtons.size(); i++) {
            String name = needSetButtons.get(i).getName();
            int j = i;
            boolean isMatch = false;
            for (int k = 0; k < customButtons.size(); k++) {
                if (customButtons.get(k).getName().equals(name)) {
                    j = k;
                    isMatch = true;
                }
            }
            if (isMatch) {
                customButtons.set(j, needSetButtons.get(i));
            } else if (customButtons.size() <= i) {
                customButtons.add(needSetButtons.get(i));
            }
        }
    }

    public static void main(String[] args) {
        String wechatMenuJson =
            "{'button':[{'type':'click','name':'今日歌曲','key':'V1001_TODAY_MUSIC'},{'name':'菜单','sub_button':[{'type':'view','name':'搜索','url':'http://www.soso.com/'},{'type':'view','name':'视频','url':'http://v.qq.com/'},{'type':'click','name':'赞一下我们','key':'V1001_GOOD'}]}]}";
        covertJsonToMenu(wechatMenuJson);
    }

}
