/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizerInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatCustomMenuDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatCustomMenu;
import com.baijia.tianxiao.dal.wechat.po.UnifiedWechatAccount;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.sal.common.api.OrganizationInfoAPIService;
import com.baijia.tianxiao.sal.wechat.api.AuthorizationInfoService;
import com.baijia.tianxiao.sal.wechat.api.CustomMenuService;
import com.baijia.tianxiao.sal.wechat.api.UnifiedWechatAccountService;
import com.baijia.tianxiao.sal.wechat.api.WechatFreeVersionService;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.constant.SalWechatErrorCode;
import com.baijia.tianxiao.sal.wechat.constant.WechatApi;
import com.baijia.tianxiao.sal.wechat.constant.custommenu.FreeVersionMenuClick;
import com.baijia.tianxiao.sal.wechat.constant.custommenu.MenuCustomJsonKey;
import com.baijia.tianxiao.sal.wechat.constant.custommenu.WechatMenuJsonKey;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.dto.custommenu.CustomMenuBtn;
import com.baijia.tianxiao.sal.wechat.dto.custommenu.CustomMenuDto;
import com.baijia.tianxiao.sal.wechat.dto.custommenu.MenuConvertResult;
import com.baijia.tianxiao.sal.wechat.dto.mediatype.OrgWechatDto;
import com.baijia.tianxiao.sal.wechat.dto.menu.Menu;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.menu.WechatMenuApiHelper;
import com.baijia.tianxiao.sal.wechat.helper.menu.WechatMenuBtnBuilder;
import com.baijia.tianxiao.sal.wechat.helper.menu.WechatMenuJsonConverter;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;
import com.baijia.tianxiao.sal.wechat.util.MenuUtils;
import com.baijia.tianxiao.sal.wechat.validator.WechatApiValidator;
import com.baijia.tianxiao.util.GenericsUtils;

import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

/**
 * @title : CustomMenuServiceImpl
 * @description : 微信自定义菜单
 * @author : zhenyujian
 * @date : 2016年1月8日 下午3:07:37
 */
@Slf4j
@Service
public class CustomMenuServiceImpl implements CustomMenuService {

    @Autowired
    private AuthorizationInfoService authorizationInfoService;
    @Autowired
    private WechatFreeVersionService freeVersionService;
    @Autowired
    private OrgWechatCustomMenuDao orgWechatCustomMenuDao;
    @Autowired
    private AuthorizerInfoDao authorizerInfoDao;
    @Autowired
    private UnifiedWechatAccountService unifiedWechatAccountService;
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;
    @Autowired
    private OrganizationInfoAPIService organizationInfoAPIService;

    @Override
    public boolean syncCustomMenu(int orgId) {
        return false;
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void saveAndBuildCustomMenu(int orgId, String menuJson, Boolean...needTrans) {
        AuthorizationInfo authorizationInfo = null;

        boolean needTrans_ = true;
        if (GenericsUtils.notNullAndEmpty(needTrans)) {
            needTrans_ = needTrans[0];
        }
        // 统一公众号校区进行公众号绑定的时候涉及到机构公众号自定义菜单栏的更新,但refershAccessToken的方法是新开事务去做的,看不到外层事务插入的authorization对象
        if (needTrans_) {
            authorizationInfo = authorizationInfoService.refreshAccessToken(orgId);
        } else {
            authorizationInfo = this.authorizationInfoDao.getByOrgId(orgId);
        }
        AuthorizerInfo authorizerInfo = authorizerInfoDao.getByOrgId(orgId);

        // 权限判断
        WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MENU);

        OrgAccount orgAccount = null;
        try {
            orgAccount = organizationInfoAPIService.findOrgAccountWithOrgId((long) orgId);
        } catch (Exception e) {
            GenericsUtils.logErrorAndInfo(log, e, "can not find orgAccount with orgId:{}", orgId);
            return;
        }
        OrgWechatDto orgWechatDto =
            new OrgWechatDto(orgAccount.getId(), orgAccount.getNumber(), authorizerInfo.getAuthorizerAppId());

        // json格式转换
        MenuConvertResult result = null;
        try {
            UnifiedWechatAccount findUnifiedWechatAccountWithOrgId =
                this.unifiedWechatAccountService.findUnifiedWechatAccountWithOrgId(orgId);
            // 对于使用了统一公众号的机构进行特定URL的设置,在此进行特殊标示
            if (findUnifiedWechatAccountWithOrgId != null && findUnifiedWechatAccountWithOrgId.isMaster()
                && findUnifiedWechatAccountWithOrgId.isInitOver()) {
                orgWechatDto.setUnifiedWechatAccount(true);
            }
            result = WechatMenuJsonConverter.customJsonToWechatMenuJson(orgWechatDto, menuJson);
        } catch (ParameterException e) {
            log.warn("saveAndBuildCustomMenu- orgWechatDto:{},menuJson:{}", orgWechatDto, menuJson);
            log.warn("saveAndBuildCustomMenu- exception", e);
            throw e;
        } catch (Exception e) {
            log.warn("saveAndBuildCustomMenu- orgWechatDto:{},menuJson:{}", orgWechatDto, menuJson);
            log.error("saveAndBuildCustomMenu- exception", e);
            return;
        }

        OrgWechatCustomMenu menu = orgWechatCustomMenuDao.getByAuthorizerAppId(authorizerInfo.getAuthorizerAppId());

        Date now = new Date();
        if (result.getWechatJson() != null) {
            if (menu == null) {
                menu = new OrgWechatCustomMenu();
                menu.setAuthorizerAppId(authorizerInfo.getAuthorizerAppId());
                menu.setCreateTime(now);
                menu.setUpdateTime(now);
                menu.setJson(result.getCustomJson());
                orgWechatCustomMenuDao.save(menu, true);
            } else {
                menu.setUpdateTime(now);
                menu.setJson(result.getCustomJson());
                orgWechatCustomMenuDao.update(menu, true);
            }
            // 生成自定义菜单
            WechatMenuApiHelper.createMenu(authorizationInfo.getAuthorizerAccessToken(), result.getWechatJson());
        } else {
            if (menu != null) {
                orgWechatCustomMenuDao.delById(menu.getId());
                WechatMenuApiHelper.deleteMenu(authorizationInfo.getAuthorizerAccessToken());
            }
        }
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public CustomMenuDto getCustomMenu(int orgId) {
        CustomMenuDto dto = null;

        AuthorizerInfo authorizerInfo = authorizerInfoDao.getByOrgId(orgId);
        AuthorizationInfo authorizationInfo = authorizationInfoDao.getByOrgId(orgId);
        if(authorizationInfo != null && authorizationInfo.isAccessTokenExpired()){
            authorizationInfo = this.authorizationInfoService.refreshAccessToken(orgId);
        }

        // 权限判断
        WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.MENU);

        OrgWechatCustomMenu menu = orgWechatCustomMenuDao.getByAuthorizerAppId(authorizerInfo.getAuthorizerAppId());

        log.info("OrgWechatCustomMenu is :{} ", menu);
        if (menu == null) {
            try {
                // 同步微信menu数据
                WechatApiResponse result = WechatMenuApiHelper.getMenu(authorizationInfo.getAuthorizerAccessToken());
                String wechatJson = result.getJsonStr();
                MenuConvertResult mcResult = WechatMenuJsonConverter.wechatMenuJsonToCustomJson(wechatJson);
                if (mcResult.getCustomJson() != null) {
                    Date now = new Date();
                    menu = new OrgWechatCustomMenu();
                    menu.setAuthorizerAppId(authorizationInfo.getAuthorizerAppId());
                    menu.setCreateTime(now);
                    menu.setUpdateTime(now);
                    menu.setJson(mcResult.getCustomJson());
                    orgWechatCustomMenuDao.save(menu, true);
                }
            } catch (Exception e) {
            }
        }

        if (menu != null) {
            dto = new CustomMenuDto();
            dto.setAuthorizerAppId(menu.getAuthorizerAppId());
            dto.setCreateTime(menu.getCreateTime());
            dto.setId(menu.getId());
            dto.setJson(menu.getJson());
        }
        return dto;
    }

    /**
     * 针对统一公众号的底部菜单栏,进行逐个处理以判断用户是否存在这些配置.
     * 
     * @param authorizerInfo
     * @param needSetMenu
     */
    @Override
    @Transactional(rollbackFor = Exception.class, propagation = Propagation.REQUIRED)
    public void updateOrgWechatMenu(AuthorizerInfo authorizerInfo, String needSetMenuJson, boolean needWebApiCheck) {
        if (authorizerInfo == null || GenericsUtils.isNullOrEmpty(needSetMenuJson)) {
            return;
        }
        Integer orgId = authorizerInfo.getOrgId();
        if (needWebApiCheck) {
            AuthorizationInfo refreshAccessToken = this.authorizationInfoDao.getByOrgId(orgId);
            // 对于非认证服务号的公众号无法进行网页授权操作,在未使用uid的时候无法获取用户的唯一标示,故无法参与多校区的聊天操作,在此进行公众号类型的限制
            checkoutOrgWechatType(authorizerInfo, refreshAccessToken);
        }
        // 获取到现有系统里面公众号自定义菜单的设置
        CustomMenuDto customMenuDto = null;
        try {
            customMenuDto = this.getCustomMenu(orgId);
        } catch (Exception e1) {
            GenericsUtils.logErrorAndInfo(log, e1, "can not get customMenu for {} ", authorizerInfo);
            return;
        }
        OrgAccount orgAccount = null;
        try {
            orgAccount = organizationInfoAPIService.findOrgAccountWithOrgId((long) orgId);
        } catch (Exception e) {
            GenericsUtils.logErrorAndInfo(log, e, "can not find orgAccount with orgId:{}", orgId);
            return;
        }
        OrgWechatDto orgWechatDto =
            new OrgWechatDto(orgAccount.getId(), orgAccount.getNumber(), authorizerInfo.getAuthorizerAppId());

        Menu needSetMenu = null;
        MenuConvertResult mcResultForNeedSetMenu =
            WechatMenuJsonConverter.customJsonToWechatMenuJson(orgWechatDto, needSetMenuJson);
        needSetMenu = MenuUtils.covertJsonToMenu(mcResultForNeedSetMenu.getWechatJson());
        Menu customMenu = null;
        if (customMenuDto != null) {
            MenuConvertResult mcResult =
                WechatMenuJsonConverter.customJsonToWechatMenuJson(orgWechatDto, customMenuDto.getJson());
            customMenu = MenuUtils.covertJsonToMenu(mcResult.getWechatJson());
            MenuUtils.compareAndSetCustomMenu(needSetMenu, customMenu);
        } else {
            customMenu = needSetMenu;
        }
        MenuConvertResult wechatMenuJsonToCustomJson = WechatMenuJsonConverter.wechatMenuJsonToCustomJson(customMenu);
        log.info("reset customMenuJson :{} ", wechatMenuJsonToCustomJson.getCustomJson());
        try {
            this.saveAndBuildCustomMenu(orgId, wechatMenuJsonToCustomJson.getCustomJson(), false, false);
        } catch (Exception e) {
            GenericsUtils.logErrorAndInfo(log, e, "can not initCustomMenu for orgId:{}", orgId);
        }
    }

    /**
     * @param authorizerInfo
     * @param refreshAccessToken
     */
    private void checkoutOrgWechatType(AuthorizerInfo authorizerInfo, AuthorizationInfo authorizationInfo) {
        // 权限判断
        try {
            WechatApiValidator._4CallApi(authorizationInfo, authorizerInfo, WechatApi.USER_WEBAUTH);
        } catch (BussinessException e) {
            throw new BussinessException(SalWechatErrorCode.WECHAT_WEB_AUTH_FAIL, "当前公众号无法进行网页授权,请使用认证服务号进行统一公众号功能的设置");
        }
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public String getQuickMenuJson(int orgId) {
        AuthorizerInfo authorizerInfo = authorizerInfoDao.getByOrgId(orgId);
        OrgAccount orgAccount = null;
        try {
            orgAccount = organizationInfoAPIService.findOrgAccountWithOrgId((long) orgId);
        } catch (Exception e) {
            GenericsUtils.logErrorAndInfo(log, e, "can not find orgAccount with orgId:{}", orgId);
            return "";
        }
        OrgWechatDto orgWechatDto =
            new OrgWechatDto(orgAccount.getId(), orgAccount.getNumber(), authorizerInfo.getAuthorizerAppId());

        boolean isUnifiedWechatAccount = false;
        UnifiedWechatAccount findMasterAccountWithAnyCampusOrgId =
            this.unifiedWechatAccountService.findMasterAccountWithAnyCampusOrgId(orgId, true);
        if (findMasterAccountWithAnyCampusOrgId != null
            && findMasterAccountWithAnyCampusOrgId.getDelStatus() == DeleteStatus.NORMAL.getValue()) {
            log.info("wechat is under unified control :{} ", orgId);
            isUnifiedWechatAccount = true;
        }
        orgWechatDto.setUnifiedWechatAccount(isUnifiedWechatAccount);
        JSONObject json = new JSONObject();
        JSONArray btnArray = new JSONArray();
        CustomMenuBtn btn;
        List<CustomMenuBtn> subButton;

        // 菜单1
        subButton = new ArrayList<CustomMenuBtn>();
        subButton.add(CustomMenuBtn.buildViewBtn(MediaType.WANGXIAOZHUYE, orgWechatDto));
        subButton.add(CustomMenuBtn.buildViewBtn(MediaType.KECHENGLIEBIAO, orgWechatDto));
        subButton.add(CustomMenuBtn.buildViewBtn(MediaType.XIAOQUDIZHI, orgWechatDto));
        subButton.add(CustomMenuBtn.buildViewBtn(MediaType.DIANHUA, orgWechatDto));
        if (isUnifiedWechatAccount) {
            subButton.add(CustomMenuBtn.buildViewBtn(MediaType.ZAIXIANZIXUN, orgWechatDto));
        } else {
            subButton.add(CustomMenuBtn.buildTextBtn(MediaType.ZAIXIANZIXUN, "请点击页面左下方的键盘按钮，切换到在线交谈模式。", orgWechatDto));
        }
        btn = CustomMenuBtn.buildHierarchyBtn(MediaType.WEIGUANWANG, orgWechatDto, subButton);
        btnArray.add(btn.toJson());

        // 菜单2
        btnArray.add(CustomMenuBtn.buildViewBtn(MediaType.YUYUESHITING, orgWechatDto).toJson());

        // 菜单3
        if (authorizerInfo.hasWebAuthPermission()) {
            subButton = new ArrayList<CustomMenuBtn>();
            subButton.add(CustomMenuBtn.buildViewBtn(MediaType.XUESHENGZHONGXIN, orgWechatDto));
            subButton.add(CustomMenuBtn.buildViewBtn(MediaType.LAOSHIZHONGXIN, orgWechatDto));
            btn = CustomMenuBtn.buildHierarchyBtn(MediaType.GERENZHONGXIN, orgWechatDto, subButton);
            btnArray.add(btn.toJson());
        }
        json.put(MenuCustomJsonKey.BUTTON, btnArray);

        return json.toString();
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void mediaTypeConvert() {
        List<OrgWechatCustomMenu> list = orgWechatCustomMenuDao.getAll();
        log.info("mediaTypeConvert list size:{}", list);
        for (OrgWechatCustomMenu menu : list) {
            String json = menu.getJson();
            json = json.replace("\"mediaType\":\"15\",\"name\":\"预约试听\"", "\"mediaType\":\"23\",\"name\":\"预约试听\"");
            json = json.replace("\"mediaType\":\"15\",\"name\":\"校区地址\"", "\"mediaType\":\"20\",\"name\":\"预约试听\"");
            json = json.replace("\"mediaType\":\"15\",\"name\":\"学生中心\"", "\"mediaType\":\"25\",\"name\":\"预约试听\"");
            json = json.replace("\"mediaType\":\"15\",\"name\":\"老师中心\"", "\"mediaType\":\"26\",\"name\":\"预约试听\"");
            json = json.replace("\"mediaType\":\"6\",\"name\":\"400电话\"", "\"mediaType\":\"21\",\"name\":\"预约试听\"");
            json = json.replace("\"mediaType\":\"6\",\"name\":\"在线咨询\"", "\"mediaType\":\"22\",\"name\":\"预约试听\"");
            menu.setJson(json);
            orgWechatCustomMenuDao.update(menu);
        }
    }

    @Override
    public String createCampusListUrl(Integer orgNumber, String appId) {
        StringBuilder sb = new StringBuilder(WechatProperties.getWebMTianXiaoUrlPrefix());
        sb.append(String.format(WechatProperties.getCampusListUrlFormat(), orgNumber, appId));
        log.info("sb toString is :{} ", sb.toString());
        String campusListUrl = WechatWebAuthLinkBuilder.fansinfo(WebAuthScope.BASE, appId, sb.toString());
        return campusListUrl;
    }

    @Override
    public String createMenuForFreeVersion() {
        AuthorizerInfo authorizerInfo = freeVersionService.getFAAuthorizerInfo();
        AuthorizationInfo authorizationInfo = authorizationInfoService.refreshAccessToken(authorizerInfo.getOrgId());

        JSONObject json = new JSONObject();
        JSONArray btnArray = new JSONArray();

        btnArray.add(WechatMenuBtnBuilder.clickBtn(FreeVersionMenuClick.STUDNET_CENTER.getName(),
            FreeVersionMenuClick.STUDNET_CENTER.getKey()));
        btnArray.add(WechatMenuBtnBuilder.clickBtn(FreeVersionMenuClick.TEACHER_CENTER.getName(),
            FreeVersionMenuClick.TEACHER_CENTER.getKey()));

        json.put(WechatMenuJsonKey.BUTTON, btnArray);

        WechatMenuApiHelper.createMenu(authorizationInfo.getAuthorizerAccessToken(), json.toString());
        return json.toString();
    }

    /**
     * 更新机构400电话按钮,将类型改为链接跳转
     */
    @Override
    public void update400Menu() {
        // TODO
    }

    public static void main(String[] args) {
        System.out.println(MediaType.DIANHUA.getNote());
    }

}
