/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper.openplat;

import java.util.Map;

import javax.xml.ws.WebServiceException;

import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.WechatRemoteCallHelper;
import com.google.common.collect.Maps;

/**   
 * @Title       : OpenPlatformApiCaller 
 * @Description : 微信开放平台api访问
 * @Author      : zhenyujian
 * @Date        : 2015年12月3日 上午11:01:58 
 */
public class OpenPlatApiCaller {
	
	
	/**
	 * @Description  : 获取 ComponentAccessToken
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月3日 上午11:03:49 
	 *
	 * @Return       : Map<String,Object>
	 */
	public static WechatApiResponse requestComponentAccessToken(String componentAppId, String componentAppSecret, String componentVerifyTicket)  throws WechatException, WebServiceException{
        String url = "https://api.weixin.qq.com/cgi-bin/component/api_component_token";
        Map<String, Object> params = Maps.newHashMap();
        params.put("component_appid", componentAppId);
        params.put("component_appsecret", componentAppSecret);
        params.put("component_verify_ticket", componentVerifyTicket);
        return WechatRemoteCallHelper.postJson(url, params);
    }

	public static void main(String args[]){
		System.out.println(requestComponentAccessToken("wxe3e8b29a095c7a4f", "0c79e1fa963cd80cc0be99b20a18faeb", "ticket@@@4hKPY-2M75OaCWn7awgPbTK9VC_HHDjPIUiIvXxyyD5b9gPoPhlvpAcfFT0QnpTxYlILMvN3DisFwZOJi6-q7w"));
	}
	
	/**
	 * @Description  : 获取 PreAuthCode
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月3日 下午1:54:22 
	 *
	 * @Return       : String
	 */
	public static WechatApiResponse requestPreAuthCode(String componentAppId, String componentAccessToken)  throws WechatException, WebServiceException{
		String url = "https://api.weixin.qq.com/cgi-bin/component/api_create_preauthcode?component_access_token="
	                 + componentAccessToken;
	    Map<String, Object> params = Maps.newHashMap();
	    params.put("component_appid", componentAppId);
	    return WechatRemoteCallHelper.postJson(url, params);
	}
	
	
    /**
     * @Description  : 使用授权码换取公众号的授权信息
     * @Author       : zhenyujian
     * @Date         : 2015年12月3日 下午2:45:42 
     *
     * @Return       : Map<String,Object>
     */
    public static WechatApiResponse requestAuthorizationInfo(String componentAppId, String componentAccessToken, String authCode)  throws WechatException, WebServiceException{
        String url = "https://api.weixin.qq.com/cgi-bin/component/api_query_auth?component_access_token=" + componentAccessToken;
        Map<String, Object> params = Maps.newHashMap();
        params.put("component_appid", componentAppId);
        params.put("authorization_code", authCode);
        return WechatRemoteCallHelper.postJson(url, params);
    }

    
    /**
     * @Description  : 获取授权方信息
     * @Author       : zhenyujian
     * @Date         : 2015年12月3日 下午2:45:43 
     *
     * @Return       : Map<String,Object>
     */
    public static WechatApiResponse requestAuthorizerInfo(String componentAppId, String componentAccessToken, String authorizerAppId)  throws WechatException, WebServiceException{
        String url = "https://api.weixin.qq.com/cgi-bin/component/api_get_authorizer_info?component_access_token="
                    + componentAccessToken;
        Map<String, Object> params = Maps.newHashMap();
        params.put("component_appid", componentAppId);
        params.put("authorizer_appid", authorizerAppId);
        return WechatRemoteCallHelper.postJson(url, params);
    }

    
    /**
     * @Description  : 获取（刷新）授权公众号的令牌
     * @Author       : zhenyujian
     * @Date         : 2015年12月3日 下午2:45:45 
     *
     * @Return       : Map<String,Object>
     */
    public static WechatApiResponse requestAuthorizerAccessToken(String componentAppId, String componentAccessToken,
    															   String authorizerAppId, String authorizerRefreshToken)  throws WechatException, WebServiceException{
        String url = "https://api.weixin.qq.com/cgi-bin/component/api_authorizer_token?component_access_token="
                	+ componentAccessToken;
        Map<String, Object> params = Maps.newHashMap();
        params.put("component_appid", componentAppId);
        params.put("authorizer_appid", authorizerAppId);
        params.put("authorizer_refresh_token", authorizerRefreshToken);
        return WechatRemoteCallHelper.postJson(url, params);
    }
}

