/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper.menu;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.exception.ParameterException;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.constant.custommenu.MenuCustomJsonKey;
import com.baijia.tianxiao.sal.wechat.constant.custommenu.WechatMenuBtnType;
import com.baijia.tianxiao.sal.wechat.constant.custommenu.WechatMenuJsonKey;
import com.baijia.tianxiao.sal.wechat.dto.custommenu.MenuConvertResult;
import com.baijia.tianxiao.sal.wechat.dto.mediatype.OrgWechatDto;
import com.baijia.tianxiao.sal.wechat.dto.menu.Button;
import com.baijia.tianxiao.sal.wechat.dto.menu.ClickButton;
import com.baijia.tianxiao.sal.wechat.dto.menu.ComplexButton;
import com.baijia.tianxiao.sal.wechat.dto.menu.MediaButton;
import com.baijia.tianxiao.sal.wechat.dto.menu.Menu;
import com.baijia.tianxiao.sal.wechat.dto.menu.ViewButton;
import com.baijia.tianxiao.sal.wechat.dto.menu.ViewLimitedButton;
import com.baijia.tianxiao.sal.wechat.util.RandomUtil;
import com.baijia.tianxiao.sal.wechat.validator.CustomMenuValidator;
import com.baijia.tianxiao.util.GenericsUtils;

import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONNull;
import net.sf.json.JSONObject;

/**
 * @title : WechatMenuJsonConverter
 * @description : 自定义json 与 微信定义json 格式转换 http://mp.weixin.qq.com/wiki/10/0234e39a2025342c17a7d23595c6b40a.html
 * @author : zhenyujian
 * @date : 2016年1月8日 下午4:33:51
 */
@Slf4j
public class WechatMenuJsonConverter {

    /**
     * @Description : 自定菜单 - 自定义json格式 转换 微信json格式
     * @Author : zhenyujian
     * @Date : 2016年1月8日 下午4:34:10
     *
     * @Return : String
     */
    public static MenuConvertResult customJsonToWechatMenuJson(OrgWechatDto orgWechatDto, String menuJsonStr) {
        if (StringUtils.isBlank(menuJsonStr) || menuJsonStr.equals("{}")) {
            return new MenuConvertResult(menuJsonStr, null);
        }

        JSONObject wechatMenuJson = new JSONObject();
        JSONArray wechatBtnArray = new JSONArray();

        log.info("menus is :{} ", menuJsonStr);
        // 解析自定义的json格式 转换为 微信api要求的json格式
        JSONObject menuJson = JSONObject.fromObject(menuJsonStr);
        log.info("menusJson is :{} ", menuJsonStr);

        JSONArray btnArray = menuJson.optJSONArray(MenuCustomJsonKey.BUTTON);
        if (btnArray == null || btnArray.size() == 0) {
            return new MenuConvertResult(menuJsonStr, null);
        }

        if (btnArray != null && !btnArray.isEmpty()) {
            for (int i = 0; i < btnArray.size(); i++) {
                JSONObject wechatBtn = null;

                JSONObject btn = btnArray.getJSONObject(i);

                // 你懂的
                try {
                    if (btn.optString(MenuCustomJsonKey.TYPE, "").equals("")
                        && btn.get(MenuCustomJsonKey.SUB_BUTTON) != null
                        && !btn.get(MenuCustomJsonKey.SUB_BUTTON).equals("null")
                        && btn.getJSONArray(MenuCustomJsonKey.SUB_BUTTON).size() == 0) {
                        throw new ParameterException("按钮 " + btn.getString(MenuCustomJsonKey.NAME) + " 格式不合法.");
                    }
                } catch (Exception e) {
                    throw new ParameterException("按钮 " + btn.getString(MenuCustomJsonKey.NAME) + " 格式不合法.");
                }

                if (btn.get(MenuCustomJsonKey.SUB_BUTTON) == null
                    || btn.get(MenuCustomJsonKey.SUB_BUTTON).equals("null")
                    || btn.getJSONArray(MenuCustomJsonKey.SUB_BUTTON).size() == 0) {
                    // 一级菜单
                    CustomMenuValidator._4ButtonName(btn.getString(MenuCustomJsonKey.NAME));
                    wechatBtn = btnToWechatBtn(orgWechatDto, btn);
                } else {
                    // 二级菜单
                    wechatBtn = new JSONObject();
                    wechatBtn.put(WechatMenuJsonKey.NAME, btn.getString(MenuCustomJsonKey.NAME));
                    wechatBtn.put(WechatMenuJsonKey.SUB_BUTTON,
                        subBtnToWechatSubBtn(orgWechatDto, btn.getJSONArray(MenuCustomJsonKey.SUB_BUTTON)));

                    btn.remove(MenuCustomJsonKey.TYPE);
                    btn.remove(MenuCustomJsonKey.MEDIA_ID);
                    btn.remove(MenuCustomJsonKey.CONTENT);
                    btn.remove(MenuCustomJsonKey.URL);
                }

                wechatBtnArray.add(wechatBtn);
            }
        }

        log.info("wechatBtnArray is :{} ", wechatBtnArray);

        wechatMenuJson.put(WechatMenuJsonKey.BUTTON, wechatBtnArray);

        return new MenuConvertResult(menuJson.toString(), wechatMenuJson.toString());
    }

    private static JSONArray subBtnToWechatSubBtn(OrgWechatDto orgWechatDto, JSONArray subBtnArray) {
        JSONArray wechatSubBtnArray = new JSONArray();
        if (subBtnArray != null && !subBtnArray.isEmpty()) {
            for (int i = 0; i < subBtnArray.size(); i++) {
                CustomMenuValidator._4SubButtonName(subBtnArray.getJSONObject(i).getString(MenuCustomJsonKey.NAME));
                JSONObject wechatSubBtn = btnToWechatBtn(orgWechatDto, subBtnArray.getJSONObject(i));
                if (wechatSubBtn != null) {
                    wechatSubBtnArray.add(wechatSubBtn);
                }
            }
        }

        return wechatSubBtnArray;
    }

    private static JSONObject btnToWechatBtn(OrgWechatDto orgWechatDto, JSONObject btn) {
        JSONObject wechatBtn = null;

        MediaType type = MediaType.getByVaule(btn.getInt(MenuCustomJsonKey.TYPE));
        if (MediaType.UNKNOWN == type) {// 占位元素
            return null;
        }

        String name = btn.optString(MenuCustomJsonKey.NAME, "");
        String mediaId = btn.optString(MenuCustomJsonKey.MEDIA_ID, "");
        Object urlObj = btn.get(MenuCustomJsonKey.URL); // json 会把 "url":null ---> "url":JSONNull("null");
                                                        // 可能只是JSONObject API的问题
        String url = "";
        if (urlObj != null && !(urlObj instanceof JSONNull)) {
            url = urlObj.toString();
        }
        if (StringUtils.isBlank(url)) {
            url = type.getUrl(orgWechatDto);
        }
        boolean isContent = false;
        isContent = isContentForUnifiedWechatAccount(type, orgWechatDto, url);

        if (StringUtils.isBlank(name)) {
            name = type.getLabel();
        }

        if (MediaType.IMAGE == type) {
            // 图片消息
            wechatBtn = WechatMenuBtnBuilder.mediaBtn(name, mediaId);

        } else if (MediaType.VOICE == type) {
            // 语音消息
            // TODO

        } else if (MediaType.VIDEO == type) {
            // 视频消息
            // TODO

        } else if (MediaType.THUMB == type) {
            // 语音消息
            // TODO

        } else if (MediaType.NEWS == type) {
            // 图文消息
            wechatBtn = WechatMenuBtnBuilder.mediaBtn(name, mediaId);
        } else if (isContent) {
            log.debug("btn is clickType btn :{} ", btn);
            // 文本消息
            String key = RandomUtil.str(10);
            wechatBtn = WechatMenuBtnBuilder.clickBtn(name, key);
            // 为避免原有系统里面用户设置的点击菜单栏的响应内容丢失,
            // 这里如果判断原有文本里面存在，则将其设置到wechatBtn,保证后面根据wechat格式转为custom格式的时候内容不丢失
            if (btn.containsKey(MenuCustomJsonKey.CONTENT)) {
                wechatBtn.put(MenuCustomJsonKey.CONTENT, btn.get(MenuCustomJsonKey.CONTENT));
            }
            btn.put(MenuCustomJsonKey.CLICK_KEY, key);
        } else {
            log.debug("btn is :{} ", btn);
            if (StringUtils.isBlank("url")) {
                throw new ParameterException("操作失败, 按钮 ‘" + name + "’ 未设置访问地址。");
            }
            // 链接消息
            if (!(url.startsWith("http") || url.startsWith("https"))) {
                url = "http://" + url;
            }
            wechatBtn = WechatMenuBtnBuilder.viewBtn(name, url);
            btn.put(MenuCustomJsonKey.URL, wechatBtn.getString(WechatMenuJsonKey.URL));
        }

        return wechatBtn;
    }

    private static boolean isContentForUnifiedWechatAccount(MediaType type, OrgWechatDto orgWechatDto, String url) {
        boolean isContent = false;
        if (isContent(type.getValue())) {
            // 1.电话在统一公众号功能之后统一换成链接的格式,但以前的数据未修改,在此保持电话为文本类型
            // 2.如果判断当前的公众号是作为统一公众号进行菜单项生成的,如果是文本类型,但url为null,可能为【在线咨询】,在线咨询既可以保持为点击菜单或跳转校区列表进行IM咨询
            if (orgWechatDto.isUnifiedWechatAccount() && GenericsUtils.notNullAndEmpty(url)) {
                isContent = false;
            } else if (GenericsUtils.isNullOrEmpty(url)) {
                // 3.针对用户手动新建菜单项,url是在这一步判断前生成的(统一公众号会生成一些菜单项的url),如果前一步没有生成,说明是文本
                isContent = true;
            }
        }
        return isContent;
    }

    /**
     * @param type
     * @param url
     * @param isContent
     * @return
     */
    private static boolean isContentForUnifiedWechatAccount(MediaType type, String url) {
        boolean isContent = false;
        if (isContent(type.getValue())) {
            if (!type.isCanSetToUnifiedWechat()) {
                isContent = true;
            } else {
                if (GenericsUtils.isNullOrEmpty(url)) {
                    isContent = true;
                }
            }
        }
        return isContent;
    }

    public static Map<String, String> mapClickKeyVsContent(String menuJsonStr) {
        Map<String, String> map = new HashMap<String, String>();
        JSONObject menuJson = JSONObject.fromObject(menuJsonStr);

        JSONArray btnArray = menuJson.optJSONArray(MenuCustomJsonKey.BUTTON);
        if (btnArray != null && !btnArray.isEmpty()) {
            for (int i = 0; i < btnArray.size(); i++) {

                JSONObject btn = btnArray.getJSONObject(i);
                int type = btn.optInt(MenuCustomJsonKey.TYPE, -1);
                if (type == -1) {
                    // 二级菜单
                    JSONArray subBtnArray = btn.getJSONArray(MenuCustomJsonKey.SUB_BUTTON);
                    if (subBtnArray != null && !subBtnArray.isEmpty()) {
                        for (int j = 0; j < subBtnArray.size(); j++) {
                            btn = subBtnArray.getJSONObject(j);
                            Object urlObj = btn.get(MenuCustomJsonKey.URL); // json 会把 "url":null --->
                                                                            // "url":JSONNull("null");
                            String url = "";
                            if (urlObj != null && !(urlObj instanceof JSONNull)) {
                                url = urlObj.toString();
                            }
                            MediaType typeMenu = MediaType.getByVaule(btn.getInt(MenuCustomJsonKey.TYPE));
                            log.info("btn is :{} ", btn);
                            if (typeMenu != null && isContentForUnifiedWechatAccount(typeMenu, url)) {
                                map.put(btn.getString(MenuCustomJsonKey.CLICK_KEY),
                                    btn.optString(MenuCustomJsonKey.CONTENT));
                            }
                        }
                    }
                } else if (isContent(type)) {
                    map.put(btn.getString(MenuCustomJsonKey.CLICK_KEY), btn.optString(MenuCustomJsonKey.CONTENT));
                }
            }
        }

        return map;
    }

    private static boolean isContent(int mtype) {
        if (mtype == MediaType.CONTENT.getValue() || mtype == MediaType.DIANHUA.getValue()
            || mtype == MediaType.ZAIXIANZIXUN.getValue()) {
            return true;
        }
        return false;
    }

    /*
     * 自定义menujson格式
     * 
     * { "button":[ { "type": 5, //图文素材 "name":"图文素材", "note":"", "mediaId":"xxxxx" }, { "name":"菜单", "sub_button":[ {
     * "type": 1, "name":"网校主页", "note":"" }, { "type":6, "name":"文字", "content":"文字内容", "note":"" }, { "type":4,
     * "name":"课程单页", "url" :"xxxx", "note":"" }] }] }
     */

    /**
     * @Description : 自定菜单 - 自定义json格式 转换 微信json格式
     * @Author : zhenyujian
     * @Date : 2016年1月8日 下午4:34:10
     *
     * @Return : String
     */
    public static MenuConvertResult wechatMenuJsonToCustomJson(String wechatMenuJsonStr) {
        if (StringUtils.isBlank(wechatMenuJsonStr) || wechatMenuJsonStr.equals("{}")) {
            return new MenuConvertResult(null, wechatMenuJsonStr);
        }

        JSONObject customMenuJson = new JSONObject();
        JSONArray customBtnArray = new JSONArray();

        // 解析微信api要求的json格式 转换为 自定义的json格式
        JSONObject wechatMenuJson = JSONObject.fromObject(wechatMenuJsonStr);

        JSONArray btnArray =
            wechatMenuJson.getJSONObject(WechatMenuJsonKey.MENU).optJSONArray(WechatMenuJsonKey.BUTTON);
        if (btnArray == null || btnArray.size() == 0) {
            return new MenuConvertResult(null, wechatMenuJsonStr);
        }

        if (btnArray != null && !btnArray.isEmpty()) {
            for (int i = 0; i < btnArray.size(); i++) {
                JSONObject customBtn = null;
                JSONObject wechatBtn = btnArray.getJSONObject(i);

                if (wechatBtn.get(WechatMenuJsonKey.SUB_BUTTON) == null
                    || wechatBtn.get(WechatMenuJsonKey.SUB_BUTTON).equals("null")
                    || wechatBtn.getJSONArray(WechatMenuJsonKey.SUB_BUTTON).size() == 0) {
                    // 一级菜单
                    if (wechatBtn.get(WechatMenuJsonKey.TYPE).equals(WechatMenuBtnType.VIEW.getValue())) {
                        customBtn = new JSONObject();
                        customBtn.put(MenuCustomJsonKey.TYPE,
                            getZIDINGYILiANJIETYPE(wechatBtn.getString(WechatMenuJsonKey.NAME)));
                        customBtn.put(MenuCustomJsonKey.NAME, wechatBtn.get(WechatMenuJsonKey.NAME));
                        customBtn.put(MenuCustomJsonKey.NOTE, "[" + wechatBtn.get(WechatMenuJsonKey.NAME) + "]");
                        customBtn.put(MenuCustomJsonKey.URL, wechatBtn.get(WechatMenuJsonKey.URL));
                    }

                } else {
                    // 二级菜单
                    JSONArray cutomSubBtnArray = null;
                    JSONArray wechatSubBtnArray = wechatBtn.getJSONArray(WechatMenuJsonKey.SUB_BUTTON);
                    if (wechatSubBtnArray != null && !wechatSubBtnArray.isEmpty()) {
                        for (int j = 0; j < wechatSubBtnArray.size(); j++) {
                            JSONObject wechatSubBtn = wechatSubBtnArray.getJSONObject(j);
                            if (wechatSubBtn.get(WechatMenuJsonKey.TYPE).equals(WechatMenuBtnType.VIEW.getValue())) {
                                JSONObject customSubBtn = new JSONObject();
                                customSubBtn.put(MenuCustomJsonKey.TYPE,
                                    getZIDINGYILiANJIETYPE(wechatSubBtn.getString(WechatMenuJsonKey.NAME)));
                                customSubBtn.put(MenuCustomJsonKey.NAME, wechatSubBtn.get(WechatMenuJsonKey.NAME));
                                customSubBtn.put(MenuCustomJsonKey.NOTE,
                                    "[" + wechatSubBtn.get(WechatMenuJsonKey.NAME) + "]");
                                customSubBtn.put(MenuCustomJsonKey.URL, wechatSubBtn.get(WechatMenuJsonKey.URL));
                                if (customSubBtn != null) {
                                    if (customBtn == null) {
                                        customBtn = new JSONObject();
                                        cutomSubBtnArray = new JSONArray();
                                    }
                                    cutomSubBtnArray.add(customSubBtn);
                                }
                            }
                        }
                    }
                    if (customBtn != null) {
                        customBtn.put(MenuCustomJsonKey.NAME, wechatBtn.getString(WechatMenuJsonKey.NAME));
                        customBtn.put(MenuCustomJsonKey.NOTE, "[" + wechatBtn.getString(WechatMenuJsonKey.NAME) + "]");
                        customBtn.put(MenuCustomJsonKey.SUB_BUTTON, cutomSubBtnArray);
                    }
                }

                if (customBtn != null) {
                    customBtnArray.add(customBtn);
                }
            }
        }

        customMenuJson.put(MenuCustomJsonKey.BUTTON, customBtnArray);

        return new MenuConvertResult(customMenuJson.toString(), wechatMenuJson.toString());
    }

    public static int getZIDINGYILiANJIETYPE(String name) {
        MediaType type = MediaType.getByLabel(name);
        if (type != null) {
            return type.getValue();
        }
        return MediaType.ZIDINGYILIANJIE.getValue();
    }

    public static void main(String args[]) {

        // JSONObject btn = new JSONObject();
        // btn.put("mediaType", 22);
        // btn.put("name", "在线咨询");
        // btn.put("note", "[在线咨询]请点击页面左下方的键盘按钮，切换到在线交谈模式。");
        // btn.put("content", "请点击页面左下方的键盘按钮，切换到在线交谈模式。");
        // btnToWechatBtn(null, btn);
        // System.out.println(btn.toString());

        // String a= "{"
        // +"\"menu\":{"
        // +"\"button\":["
        // +"{"
        // +"\"type\":\"click\","
        // +"\"name\":\"今日歌曲\","
        // +"\"key\":\"V1001_TODAY_MUSIC\""
        // +"},"
        // +"{"
        // +"\"type\":\"view\","
        // +"\"name\":\"今日链接\","
        // +"\"url\":\"V1001_TODAY_MUSIC\""
        // +"},"
        // +"{"
        // +"\"name\":\"菜单\","
        // +"\"sub_button\":["
        // +"{"
        // +"\"type\":\"view\","
        // +"\"name\":\"搜索\","
        // +"\"url\":\"http://www.soso.com/\""
        // +"},"
        // +"{"
        // +"\"type\":\"view\","
        // +"\"name\":\"视频\","
        // +"\"url\":\"http://v.qq.com/\""
        // +"},"
        // +"{"
        // +"\"type\":\"click\","
        // +"\"name\":\"赞一下我们\","
        // +"\"key\":\"V1001_GOOD\""
        // +"}]"
        // +"}]"
        // +"}"
        // +"}";
        // System.out.println( wechatMenuJsonToCustomJson(a).getCustomJson() );
    }

    public static MenuConvertResult checkChange(String wechatMenuJsonStr, String dbJson) {
        if (StringUtils.isBlank(wechatMenuJsonStr) || wechatMenuJsonStr.equals("{}")) {
            return new MenuConvertResult(null, wechatMenuJsonStr);
        }

        JSONObject customMenuJson = new JSONObject();
        JSONArray customBtnArray = new JSONArray();

        // 解析微信api要求的json格式 转换为 自定义的json格式
        JSONObject wechatMenuJson = JSONObject.fromObject(wechatMenuJsonStr);

        JSONArray btnArray =
            wechatMenuJson.getJSONObject(WechatMenuJsonKey.MENU).optJSONArray(WechatMenuJsonKey.BUTTON);
        if (btnArray == null || btnArray.size() == 0) {
            return new MenuConvertResult(null, wechatMenuJsonStr);
        }

        if (btnArray != null && !btnArray.isEmpty()) {
            for (int i = 0; i < btnArray.size(); i++) {
                JSONObject customBtn = null;
                JSONObject wechatBtn = btnArray.getJSONObject(i);

                if (wechatBtn.get(WechatMenuJsonKey.SUB_BUTTON) == null
                    || wechatBtn.get(WechatMenuJsonKey.SUB_BUTTON).equals("null")
                    || wechatBtn.getJSONArray(WechatMenuJsonKey.SUB_BUTTON).size() == 0) {
                    // 一级菜单
                    if (wechatBtn.get(WechatMenuJsonKey.TYPE).equals(WechatMenuBtnType.VIEW.getValue())) {
                        customBtn = new JSONObject();

                        customBtn.put(MenuCustomJsonKey.TYPE,
                            getZIDINGYILiANJIETYPE(wechatBtn.getString(WechatMenuJsonKey.NAME)));
                        customBtn.put(MenuCustomJsonKey.NAME, wechatBtn.get(WechatMenuJsonKey.NAME));
                        customBtn.put(MenuCustomJsonKey.NOTE, "[" + wechatBtn.get(WechatMenuJsonKey.NAME) + "]");
                        customBtn.put(MenuCustomJsonKey.URL, wechatBtn.get(WechatMenuJsonKey.URL));

                        if (!dbJson.contains(wechatBtn.getString(WechatMenuJsonKey.NAME))) {
                            return null;
                        }
                    } else {
                        if (MediaType.getByLabel(wechatBtn.getString(WechatMenuJsonKey.NAME)) == null) {
                            return null;
                        }
                    }

                } else {
                    // 二级菜单
                    JSONArray cutomSubBtnArray = null;
                    JSONArray wechatSubBtnArray = wechatBtn.getJSONArray(WechatMenuJsonKey.SUB_BUTTON);
                    if (wechatSubBtnArray != null && !wechatSubBtnArray.isEmpty()) {
                        for (int j = 0; j < wechatSubBtnArray.size(); j++) {
                            JSONObject wechatSubBtn = wechatSubBtnArray.getJSONObject(j);
                            if (wechatSubBtn.get(WechatMenuJsonKey.TYPE).equals(WechatMenuBtnType.VIEW.getValue())) {
                                JSONObject customSubBtn = new JSONObject();
                                customSubBtn.put(MenuCustomJsonKey.TYPE,
                                    getZIDINGYILiANJIETYPE(wechatSubBtn.getString(WechatMenuJsonKey.NAME)));
                                customSubBtn.put(MenuCustomJsonKey.NAME, wechatSubBtn.get(WechatMenuJsonKey.NAME));
                                customSubBtn.put(MenuCustomJsonKey.NOTE,
                                    "[" + wechatSubBtn.get(WechatMenuJsonKey.NAME) + "]");
                                customSubBtn.put(MenuCustomJsonKey.URL, wechatSubBtn.get(WechatMenuJsonKey.URL));
                                if (customSubBtn != null) {
                                    if (customBtn == null) {
                                        customBtn = new JSONObject();
                                        cutomSubBtnArray = new JSONArray();
                                    }
                                    cutomSubBtnArray.add(customSubBtn);
                                }
                                if (!dbJson.contains(wechatSubBtn.getString(WechatMenuJsonKey.NAME))) {
                                    return null;
                                }
                            } else {
                                if (MediaType.getByLabel(wechatSubBtn.getString(WechatMenuJsonKey.NAME)) == null) {
                                    return null;
                                }
                            }
                        }
                    }
                    if (customBtn != null) {
                        if (!dbJson.contains(wechatBtn.getString(WechatMenuJsonKey.NAME))) {
                            return null;
                        }
                        customBtn.put(MenuCustomJsonKey.NAME, wechatBtn.getString(WechatMenuJsonKey.NAME));
                        customBtn.put(MenuCustomJsonKey.NOTE, "[" + wechatBtn.getString(WechatMenuJsonKey.NAME) + "]");
                        customBtn.put(MenuCustomJsonKey.SUB_BUTTON, cutomSubBtnArray);
                    }
                }

                if (customBtn != null) {
                    customBtnArray.add(customBtn);
                }
            }
        }

        customMenuJson.put(MenuCustomJsonKey.BUTTON, customBtnArray);

        return new MenuConvertResult(customMenuJson.toString(), wechatMenuJson.toString());
    }

    /**
     * @Desc 根据Menu对象将微信格式的json串转为当前系统格式的json格式串
     * @param menu
     * @return
     */
    public static MenuConvertResult wechatMenuJsonToCustomJson(Menu menu) {
        if (menu == null) {
            return new MenuConvertResult(null, null);
        }
        // 解析微信api要求的json格式 转换为 自定义的json格式
        List<Button> buttons = menu.getButton();
        if (GenericsUtils.isNullOrEmpty(buttons)) {
            return new MenuConvertResult(null, null);
        }
        JSONObject customMenuJson = new JSONObject();
        JSONArray customBtnArray = new JSONArray();
        for (int i = 0; i < buttons.size(); i++) {
            Button button = buttons.get(i);
            JSON retJsonObj = solveButton(button);
            customBtnArray.add(retJsonObj);
        }
        log.info("customBtnArray is :{} ", customBtnArray.toString());
        customMenuJson.put(MenuCustomJsonKey.BUTTON, customBtnArray);
        return new MenuConvertResult(customMenuJson.toString(), menu.toString());
    }

    /**
     * @param button
     * @return
     */
    private static JSON solveButton(Button button) {
        String name = button.getName();
        String note = checkForNumStart(name);
        JSON customBtn = null;
        Map<String, Object> strMap = new HashMap<>();
        strMap.put(MenuCustomJsonKey.NOTE, note);
        strMap.put(MenuCustomJsonKey.NAME, name);
        if (button instanceof ViewButton) {
            ViewButton tempButton = (ViewButton) button;
            strMap.put(MenuCustomJsonKey.TYPE, getZIDINGYILiANJIETYPE(name));
            strMap.put(MenuCustomJsonKey.URL, tempButton.getUrl());
        } else if (button instanceof ClickButton) {
            ClickButton tempButton = (ClickButton) button;
            strMap.put(MenuCustomJsonKey.TYPE, MediaType.CONTENT.getValue());
            strMap.put(MenuCustomJsonKey.CONTENT, tempButton.getContent());
            strMap.put(MenuCustomJsonKey.CLICK_KEY, tempButton.getKey());
        } else if (button instanceof ViewLimitedButton) {
            ViewLimitedButton vb = (ViewLimitedButton) button;
            strMap.put(MenuCustomJsonKey.TYPE, MediaType.NEWS.getValue());
            strMap.put(MenuCustomJsonKey.MEDIA_ID, vb.getMedia_id());
        } else if (button instanceof MediaButton) {
            MediaButton vb = (MediaButton) button;
            strMap.put(MenuCustomJsonKey.TYPE, MediaType.IMAGE.getValue());
            strMap.put(MenuCustomJsonKey.MEDIA_ID, vb.getMedia_id());
        } else if (button instanceof ComplexButton) {
            JSONArray cutomSubBtnArray = new JSONArray();
            ComplexButton tempButton = (ComplexButton) button;
            for (Button btn : tempButton.getSub_button()) {
                JSON solveButton = solveButton(btn);
                cutomSubBtnArray.add(solveButton);
            }
            strMap.put(MenuCustomJsonKey.SUB_BUTTON, cutomSubBtnArray);
        }
        customBtn = JSONObject.fromObject(strMap);
        log.info("customBtn :{} , button:{} ", customBtn, button);
        return customBtn;
    }

    /**
     * @param name
     * @return
     */
    private static String checkForNumStart(String name) {
        String firstCharStr = String.valueOf(name.charAt(0));
        String regex = "\\d";
        boolean matches = Pattern.matches(regex, firstCharStr);
        if (matches) {
            return "[_" + name + "]";
        } else {
            return "[" + name + "]";
        }
    }

}
