/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.dto.templatemsg.batch;

import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.sal.wechat.dto.templatemsg.WechatTemplateMsg;

import lombok.Data;
import lombok.EqualsAndHashCode;
import net.sf.json.JSONObject;

/**
 * @title : BatchMsg
 * @description : 群发消息
 * @author : zhenyujian
 * @date : 2016年2月29日 下午3:41:17
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class BatchMsg extends WechatTemplateMsg {
    private Integer orgId;
    private String openId;

    private String noticeName;// 通知名称
    private String noticeNo;// 通知编号
    private String noticeDesc;// 通知摘要

    public BatchMsg() {
        this.msgType = WechateTemplateMsgType.BATCH;
    }

    /**
     * @Description : 创建微信模板消息 用于调用微信api
     * @Author : zhenyujian
     * @Date : 2016年1月6日 上午12:50:29
     *
     * @Return : String
     */
    public String buildTemplateMsg(String templateId) {
        this.first = "您收到一条自定义消息，请点击查看。\n";
        this.remark = "\n查看详情";

        JSONObject data = new JSONObject();

        data.put("keyword1", getTemplateMsgNode(noticeName));
        data.put("keyword2", getTemplateMsgNode(noticeNo));
        data.put("keyword3", getTemplateMsgNode(noticeDesc));

        return super.buildBaseTemplateMsg(openId, templateId, data).toString();
    }

    /**
     * @Description : json转换成对象
     * @Author : zhenyujian
     * @Date : 2016年1月6日 上午12:28:02
     *
     * @Return : CoursePlanMsg
     */
    public static BatchMsg fromJsonStr(String jsonStr) {
        BatchMsg msg = new BatchMsg();
        JSONObject json = JSONObject.fromObject(jsonStr);
        msg.fillBaseInfo(jsonStr);

        msg.setOrgId(json.optInt("orgId"));
        msg.setOpenId(json.optString("openId"));

        msg.setNoticeName(json.optString("noticeName"));
        msg.setNoticeNo(json.optString("noticeNo"));
        msg.setNoticeDesc(json.optString("noticeDesc"));

        return msg;
    }

    /**
     * @Description : 对象转换成json
     * @Author : zhenyujian
     * @Date : 2016年1月6日 上午12:28:12
     *
     * @Return : String
     */
    public String toJsonStr() {
        JSONObject json = super.getBaseJson();
        json.put("orgId", checkNull(this.orgId));
        json.put("openId", checkNull(this.openId));

        json.put("noticeName", checkNull(this.noticeName));
        json.put("noticeNo", checkNull(this.noticeNo));
        json.put("noticeDesc", checkNull(this.noticeDesc));

        return json.toString();
    }

    public void setOrgId(Integer orgId) {
        this.orgId = orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = Integer.parseInt(orgId.toString());
    }
}
