/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.constant.emoticons;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**   
 * @title       : WecahtEmoticons 
 * @description : 微信内置表情 
 * @author      : zhenyujian
 * @date        : 2016年1月14日 下午3:40:35 
 */
public enum WechatEmoticons{
	
	ei1 ("/::)" , "微笑"),
	ei2 ("/::~" , "撇嘴"),
	ei3 ("/::B" , "色"),
	ei4 ("/::|" , "发呆"),
	ei5 ("/:8-)", "得意"),
	ei6 ("/::<" , "流泪"),
	ei7 ("/::$" , "害羞"),
	ei8 ("/::X" , "闭嘴"),
	ei9 ("/::Z" , "睡"),
	ei10 ("/::'(", "大哭"),
	ei11 ("/::-|", "尴尬"),
	ei12 ("/::@" , "发怒"),
	ei13 ("/::P" , "调皮"),
	ei14 ("/::D" , "呲牙"),
	ei15 ("/::O" , "惊讶"),
	ei16 ("/::(" , "难过"),
	ei17 ("/::+" , "酷"),
	ei18 ("/:--b", "冷汗"),
	ei19 ("/::Q" , "抓狂"),
	ei20 ("/::T" , "吐"),
	ei21 ("/:,@P" ,"偷笑"),
	ei22 ("/:,@-D","愉快"),
	ei23 ("/::d" , "白眼"),
	ei24 ("/:,@o", "傲慢"),
	ei25 ("/::g" , "饥饿"),
	ei26 ("/:|-)", "困"),
	ei27 ("/::!" , "惊恐"),
	ei28 ("/::L" , "流汗"),
	ei29 ("/::>" , "憨笑"),
	ei30 ("/::,@", "悠闲"),
	ei31 ("/:,@f", "奋斗"),
	ei32 ("/::-S", "咒骂"),
	ei33 ("/:?" ,  "疑问"),
	ei34 ("/:,@x", "嘘"),
	ei35 ("/:,@@", "晕"),
	ei36 ("/::8" , "疯了"),
	ei37 ("/:,@!", "衰"),
	ei38 ("/:!!!", "骷髅"),
	ei39 ("/:xx" , "敲打"),
	ei40 ("/:bye", "再见"),
	ei41 ("/:wipe","擦汗"),
	ei42 ("/:dig" ,"抠鼻"),
	ei43 ("/:handclap" , "鼓掌"),
	ei44 ("/:&-(", "糗大了"),
	ei45 ("/:B-)", "坏笑"),
	ei46 ("/:<@" , "左哼哼"),
	ei47 ("/:@>" , "右哼哼"),
	ei48 ("/::-O", "哈欠"),
	ei49 ("/:>-|", "鄙视"),
	ei50 ("/:P-(", "委屈"),
	ei51 ("/::'|", "快哭了"),
	ei52 ("/:X-)", "阴险"),
	ei53 ("/::*" , "亲亲"),
	ei54 ("/:@x" , "吓"),
	ei55 ("/:8*" , "可怜"),
	ei56 ("/:pd" , "菜刀"),
	ei57 ("/:<W>" ,"西瓜"),
	ei58 ("/:beer","啤酒"),
	ei59 ("/:basketb" , "篮球"),
	ei60 ("/:oo" , "乒乓"),
	ei61 ("/:coffee" , "咖啡"),
	ei62 ("/:eat" , "饭"),
	ei63 ("/:pig" , "猪头"),
	ei64 ("/:rose" , "玫瑰"),
	ei65 ("/:fade" , "凋谢"),
	ei66 ("/:showlove" , "嘴唇"),
	ei67 ("/:heart" , "爱心"),
	ei68 ("/:break" , "心碎"),
	ei69 ("/:cake" , "蛋糕"),
	ei70 ("/:li" , "闪电"),
	ei71 ("/:bome" , "炸弹"),
	ei72 ("/:kn" , "刀"),
	ei73 ("/:footb" , "足球"),
	ei74 ("/:ladybug" , "瓢虫"),
	ei75 ("/:shit" , "便便"),
	ei76 ("/:moon" , "月亮"),
	ei77 ("/:sun" , "太阳"),
	ei78 ("/:gift" , "礼物"),
	ei79 ("/:hug" , "拥抱"),
	ei80 ("/:strong" , "强"),
	ei81 ("/:weak" , "弱"),
	ei82 ("/:share" , "握手"),
	ei83 ("/:v" , "胜利"),
	ei84 ("/:@)" , "抱拳"),
	ei85 ("/:jj" , "勾引"),
	ei86 ("/:@@" , "拳头"),
	ei87 ("/:bad" , "差劲"),
	ei88 ("/:lvu" , "爱你"),
	ei89 ("/:no" , "NO"),
	ei90 ("/:ok" , "OK"),
	ei91 ("/:love" , "爱情"),
	ei92 ("/:<L>" , "飞吻"),
	ei93 ("/:jump" , "跳跳"),
	ei94 ("/:shake" , "发抖"),
	ei95 ("/:shake" , "怄火"),
	ei96 ("/:circle" , "转圈"),
	ei97 ("/:kotow" , "磕头"),
	ei98 ("/:turn" , "回头"),
	ei99 ("/:skip" , "跳绳"),
	ei100 ("/:oY" , "投降"),
	
	;

    private String code;
    private String desc;
    
    private WechatEmoticons(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }
    
    
    public String getCode() {
		return code;
	}
	public String getDesc() {
		return desc;
	}


	public static String convert(String str){
		String fmt = "[%s]";
		
    	Matcher matcher = Pattern.compile("/:").matcher(str);
    	int count = 0;
    	while(matcher.find()){
    		count++;
    	}
    	
    	if(count>0){
	    	for(WechatEmoticons ei : WechatEmoticons.values()){
	    		if( str.contains(ei.getCode()) ){
	    			str = str.replace( ei.getCode() , String.format(fmt, ei.getDesc()) );
	    			count--;
	    		}
	    		if(count == 0){
	    			break;
	    		}
	    	}
    	}
    	
    	return str;
    }
    
}

