/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.constant;

import com.baijia.tianxiao.dal.wechat.constant.WechatPermission;

/**   
 * @title       : WechatApi 
 * @description : 微信api权限
 * 				  http://mp.weixin.qq.com/wiki/13/8d4957b72037e3308a0ca1b21f25ae8d.html
 * 				  https://open.weixin.qq.com/cgi-bin/showdocument?action=dir_list&t=resource/res_list&verify=1&id=open1419318459&lang=zh_CN
 * 
 * @author      : zhenyujian
 * @date        : 2016年1月15日 下午4:11:10 
 */
public enum WechatApi {
		
	//0 - 无权限
	//1 - 有权限
	//2 - 需申请
	
	BASE_GET_ACCESSTOKEN ("基础支持-获取access_token", null, 1, 1, 1, 1),
	BASE_GET_WECHATSERVER_IP ("基础支持-获取微信服务器IP地址", null, 1, 1, 1, 1),
	
	MSG_GET_ACCESSTOKEN ("接收消息-验证消息真实性、接收普通消息、接收事件推送", null, 1, 1, 1, 1),
	
	MSG_PASSIVE_REPLY ("发送消息-被动回复消息", null, 1, 1, 1, 1),
	MSG_CUSTOMER_SERVICE ("发送消息-客服接口", null, 0, 1, 0, 1),
	MSG_BATCH_SEND ("发送消息-群发接口", null, 0, 1, 0, 1),
	MSG_TEMPLATE_SEND ("发送消息-模板消息接口", null, 0, 0, 0, 1),
	
	USER_GROUP ("用户管理-用户分组管理", WechatPermission.USER_MANAGE, 0, 1, 0, 1),
	USER_REMARK ("用户管理-设置用户备注名", WechatPermission.USER_MANAGE, 0, 1, 0, 1),
	USER_GET_INFO ("用户管理-获取用户基本信息	", WechatPermission.USER_MANAGE, 0, 1, 0, 1),
	USER_LIST ("用户管理-获取用户列表	", WechatPermission.USER_MANAGE, 0, 1, 0, 1),
	USER_GET_LOCATION ("用户管理-获取用户地理位置	", WechatPermission.USER_MANAGE, 0, 0, 0, 1),
	USER_WEBAUTH ("用户管理-网页授权获取用户openid/用户基本信息	", WechatPermission.USER_MANAGE, 0, 0, 0, 1),
	
	PROMOTION_QR_CODE ("推广支持-生成带参数二维码	", null, 0, 0, 0, 1),
	PROMOTION_SHORT_LINK ("推广支持-长链接转短链接口", null, 0, 0, 0, 1),
	
	MENU ("界面丰富-自定义菜单", null, 0, 1, 1, 1),
	
	MEDIA ("素材管理-素材管理接口", WechatPermission.WECHAT_MEDIA, 0, 1, 0, 1),
	
	INTELLIGENT ("智能接口-语义理解接口", null, 0, 0, 0, 1),
	MORE_CUSTOM_SERVICE ("多客服-获取多客服消息记录、客服管理", null, 0, 0, 0, 1),
	
	PAY ("微信支付接口", null, 0, 0, 0, 2),
	SHOP ("微信小店接口", null, 0, 0, 0, 2),
	CARD ("微信卡券接口", null, 0, 2, 0, 2),
	DEVICE ("微信设备功能接口", null, 0, 0, 0, 2),
	
	JS_SDK_BASE ("微信JS-SDK-基础接口", null, 1, 1, 1, 1),
	JS_SDK_SHARE ("微信JS-SDK-分享接口", null, 0, 1, 0, 1),
	JS_SDK_IMAGE ("微信JS-SDK-图像接口", null, 1, 1, 1, 1),
	JS_SDK_AUDIO ("微信JS-SDK-音频接口", null, 1, 1, 1, 1),
	JS_SDK_INTELLIGENT ("微信JS-SDK-智能接口（网页语音识别）", null, 1, 1, 1, 1),
	JS_SDK_DEVICE ("微信JS-SDK-设备信息", null, 1, 1, 1, 1),
	JS_SDK_LOCATION ("微信JS-SDK-地理位置", null, 1, 1, 1, 1),
	JS_SDK_VIEW ("微信JS-SDK-界面操作", null, 1, 1, 1, 1),
	JS_SDK_SCAN ("微信JS-SDK-微信扫一扫", null, 1, 1, 1, 1),
	JS_SDK_SHOP ("微信JS-SDK-微信小店", null, 0, 0, 0, 1),
	JS_SDK_CARD ("微信JS-SDK-微信卡券", null, 0, 1, 0, 1),
	JS_SDK_PAY ("微信JS-SDK-微信支付", null, 0, 0, 0, 1),
	;
	
	
	private String desc;//接口描述
	private WechatPermission permission; //接口对应的第三方平台授权 权限集  目前微信没有详细的映射说明文档,所以暂不完整 用到哪些配置哪些
	private int unverifiedSubscribe; //未认证的订阅号 是否具备接口权限
	private int verifiedSubscribe;   //认证的订阅号 是否具备接口权限
	private int unverifiedService;   //未认证的服务号 是否具备接口权限
	private int verifiedService;     //认证的服务号 是否具备接口权限
	 
	private WechatApi(String desc, WechatPermission permission, 
					  int unverifiedSubscribe, int verifiedSubscribe,
					  int unverifiedService, int verifiedService){
		this.desc = desc;
		this.permission = permission;
		this.unverifiedSubscribe = unverifiedSubscribe;
		this.verifiedSubscribe = verifiedSubscribe;
		this.unverifiedService = unverifiedService;
		this.verifiedService = verifiedService;
	}

	
	public String getDesc() {
		return desc;
	}
	public WechatPermission getPermission() {
		return permission;
	}
	public int getUnverifiedSubscribe() {
		return unverifiedSubscribe;
	}
	public int getVerifiedSubscribe() {
		return verifiedSubscribe;
	}
	public int getUnverifiedService() {
		return unverifiedService;
	}
	public int getVerifiedService() {
		return verifiedService;
	}

	

}

