/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.api;

import com.baijia.tianxiao.sal.wechat.dto.customactivity.CustomActivityDto;

/**
 * @title : LuckyDrawService
 * @description : 微信活动 (抽奖、发活动)
 * @author : zhenyujian
 * @date : 2016年1月27日 下午10:58:25
 */
public interface CustomActivityService {

	
    /**
     * @Description  : 使用机构自己的公众号创建活动
     * @Author       : zhenyujian
     */
    public CustomActivityDto createCustomActivity(int orgId, int activityId, int activityType, String title,
    											  String description, String picUrl) throws Exception;

    
    /**
     * @Description  : 使用特定公众号为指定机构创建活动
     * @Author       : Rezar
     */
    public CustomActivityDto createCustomActivityForReplace(Integer replaceOrgId, int originOrgId, int activityId,
    														int activityType, String title, 
    														String description, String picUrl) throws Exception;

    
    /**
     * @Description  : 查询活动
     * @Author       : zhenyujian
     */
    public CustomActivityDto getCustomActivity(int activityId, int activityType);

    
    /**
     * @Description  : 删除活动
     * @Author       : zhenyujian
     */
    public void deleteCustomActivity(int activityId, int activityType);

}
