/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.impl;

import java.util.Date;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.dal.wechat.dao.WechatBackupMenuDao;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatBackupMenu;
import com.baijia.tianxiao.sal.wechat.api.WechatBackupMenuService;
import com.baijia.tianxiao.sal.wechat.dto.request.WechatMenuBackupRequest;

@Service
public class WechatBackupMenuServiceImpl implements WechatBackupMenuService {

    private static final Logger logger = LoggerFactory.getLogger(WechatBackupMenuServiceImpl.class);

    @Autowired
    private WechatBackupMenuDao wechatBackupMenuDao;

    
    @Transactional(readOnly=true)
    @Override
    public OrgWechatBackupMenu getLatestByAppId(String authorizerAppId) {
        return wechatBackupMenuDao.getLatestByAppId(authorizerAppId);
    }

    
    @Transactional(rollbackFor = Exception.class)
    @Override
    public OrgWechatBackupMenu add(WechatMenuBackupRequest request) {
        OrgWechatBackupMenu backup = new OrgWechatBackupMenu();
        backup.setCreateTime(new Date());
        backup.setMenu(request.getMenu());
        backup.setOrgId(request.getOrgId());
        backup.setAuthorizerAppId(request.getAuthorizerAppId());
        wechatBackupMenuDao.save(backup, true);
        logger.info("wechat - add backup menu:{}", backup);
        return backup;
    }
    
    

}
