/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper.user;

import java.util.HashMap;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

import com.baijia.tianxiao.exception.WebServiceException;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.WechatRemoteCallHelper;


/**   
 * @Title       : OpenPlatformApiCaller 
 * @Description : 微信公众平台 用户管理相关接口
 * @Author      : zhenyujian
 * @Date        : 2015年12月3日 上午11:01:58 
 */
public class FansServiceApiCaller {
	
	
	
	/**
	 * @Description  : 获取用户详细信息
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月7日 下午7:50:45 
	 *
	 * @Return       : WechatApiResponse
	 */
	public static WechatApiResponse getFansInfo(String accessToken, String openId)  throws WechatException, WebServiceException{
        String url = "https://api.weixin.qq.com/cgi-bin/user/info?access_token="+accessToken+"&openid="+openId+"&lang=zh_CN";
        Map<String, Object> params = new HashMap<String, Object>();
        return WechatRemoteCallHelper.postJson(url, params);
    }
	
	
	
	/**
	 * @Description  : 获取粉丝列表 
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月7日 下午7:56:50 
	 *
	 * @Return       : WechatApiResponse
	 */
	public static WechatApiResponse getFansOpenIdList(String accessToken, String nextOpenid){
		if(StringUtils.isBlank(nextOpenid)){
			nextOpenid = "";
		}
		String url = "https://api.weixin.qq.com/cgi-bin/user/get?access_token="+accessToken+"&next_openid="+nextOpenid;
        Map<String, Object> params = new HashMap<String, Object>();
        return WechatRemoteCallHelper.postJson(url, params);
	}
	
	
	
	/**
	 * @Description  : 设置微信备注 
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月7日 下午7:59:33 
	 *
	 * @Return       : WechatApiResponse
	 */
	public static WechatApiResponse remark(String accessToken, String openId, String remark){
		String url = "https://api.weixin.qq.com/cgi-bin/user/info/updateremark?access_token="+accessToken;
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("openid", openId);
        params.put("remark", remark);
        return WechatRemoteCallHelper.postJson(url, params);
	}
}

