/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper.template;

import java.util.HashMap;
import java.util.Map;

import net.sf.json.JSONObject;

import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.baijia.tianxiao.sal.wechat.helper.WechatRemoteCallHelper;

/**   
 * @Title       : WechatTemplateMsgCaller
 * @Description : 微信模板消息相关
 * 				  http://mp.weixin.qq.com/wiki/5/6dde9eaa909f83354e0094dc3ad99e05.html
 * @Author      : zhenyujian
 * @Date        : 2015年7月8日 下午3:58:48 
 * @Version     : v1.0   
 */
public class TemplateMsgCaller {
	
	
	/**
	 * @Description  : 为公众号绑定添加模板
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月6日 上午1:38:43 
	 *
	 * @Return       : WechatApiResponse
	 */
	public static WechatApiResponse bindTemplate(String accessToken, String originalTemplateId){
		String url = "https://api.weixin.qq.com/cgi-bin/template/api_add_template?access_token="+accessToken;
		
		Map<String,Object> params = new HashMap<String,Object>();
		params.put("template_id_short", originalTemplateId);
		return WechatRemoteCallHelper.postJson(url, params);
	}
	
	
	/**
	 * @Description  : 发送模板消息
	 * @Author       : zhenyujian
	 * @CreationDate : 2015年7月8日 下午5:08:48 
	 *
	 * @Return       : void
	 */
	@SuppressWarnings("unchecked")
	public static WechatApiResponse sendTemplateMsg(String accessToken, String json){
		String url = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token="+accessToken;
		return WechatRemoteCallHelper.postJson(url, JSONObject.fromObject(json));
	}
	
}

