/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper.openplat;

import java.util.Date;
import java.util.List;

import javax.xml.ws.WebServiceException;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.AuthorizerInfo;
import com.baijia.tianxiao.dal.wechat.po.ComponentAccessToken;
import com.baijia.tianxiao.dal.wechat.po.PreAuthCode;
import com.baijia.tianxiao.exception.WechatException;
import com.baijia.tianxiao.sal.wechat.constant.SalWechatErrorCode;
import com.baijia.tianxiao.sal.wechat.dto.wechatapi.WechatApiResponse;
import com.google.common.collect.Lists;

/**   
 * @Title       : OpenPlatfromApiHelper 
 * @Description : 微信api调用包装 主要负责返回结果处理、转换
 * @Author      : zhenyujian
 * @Date        : 2015年12月4日 下午2:15:02 
 */
public class OpenPlatApiHelper {
	
	private static final Logger logger = LoggerFactory.getLogger(OpenPlatApiCaller.class);
	
	
	/**
	 * @Description  : 获取 ComponentAccessToken
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月3日 上午11:03:49 
	 *
	 * @Return       : Map<String,Object>
	 */
	public static ComponentAccessToken requestComponentAccessToken(String componentAppId, String componentAppSecret, String componentVerifyTicket)  throws WechatException, WebServiceException{
        WechatApiResponse response = OpenPlatApiCaller.requestComponentAccessToken(componentAppId, componentAppSecret, componentVerifyTicket);
        
        JSONObject rootNode = response.getRootJSONObj();
        if (rootNode.get("component_access_token") == null || rootNode.get("expires_in") == null) {
            throw new WebServiceException("component_access_token not exist");
        }
        
        ComponentAccessToken componentAccessToken = new ComponentAccessToken();
        componentAccessToken.setAppId( componentAppId );
        componentAccessToken.setComponentAccessToken( rootNode.getString("component_access_token") );
        componentAccessToken.setExpiresIn( rootNode.getInt("expires_in") );
        componentAccessToken.setUpdateTime( new Date() );
        
        return componentAccessToken;
    }
	
	
	public static void main(String arg[]){
		String componentAppId = "wxe3e8b29a095c7a4f";
		String componentAppSecret = "0c79e1fa963cd80cc0be99b20a18faeb";
		String componentVerifyTicket = "ticket@@@b-sN0jJWmBha14z7o60E_2W5uazkb7_8TgCmIGn1O7i6cFSgr3kH8dBqfX3uinYdwuM6Cw3cEnOUURche8ULcg";
		System.out.println("1111");
		System.out.println(requestComponentAccessToken(componentAppId, componentAppSecret, componentVerifyTicket));
		System.out.println("222");
	}
	
	
	
	/**
	 * @Description  : 获取 PreAuthCode
	 * @Author       : zhenyujian
	 * @Date         : 2015年12月3日 下午1:54:22 
	 *
	 * @Return       : String
	 */
	public static PreAuthCode requestPreAuthCode(String componentAppId, String componentAccessToken)  throws WechatException, WebServiceException{
	    WechatApiResponse response = OpenPlatApiCaller.requestPreAuthCode(componentAppId, componentAccessToken);
	    
	    JSONObject rootNode = response.getRootJSONObj();
        if (rootNode.get("pre_auth_code") == null || rootNode.get("expires_in") == null) {
            throw new WebServiceException("pre_auth_code not exist");
        }
        
	    PreAuthCode preAuthCode = new PreAuthCode();
	    preAuthCode.setAppId( componentAppId );
	    preAuthCode.setExpiresIn( rootNode.getInt("expires_in") );
	    preAuthCode.setPreAuthCode( rootNode.getString("pre_auth_code") );
	    preAuthCode.setUpdateTime( new Date() );
	    return preAuthCode;
	}
	
	
    /**
     * @Description  : 使用授权码换取公众号的授权信息
     * @Author       : zhenyujian
     * @Date         : 2015年12月3日 下午2:45:42 
     *
     * @Return       : Map<String,Object>
     */
    public static AuthorizationInfo requestAuthorizationInfo(String componentAppId, String componentAccessToken, String authCode)  throws WechatException, WebServiceException{
        WechatApiResponse response = OpenPlatApiCaller.requestAuthorizationInfo(componentAppId, componentAccessToken, authCode);
        
        AuthorizationInfo authorizationInfo = new AuthorizationInfo();
        JSONObject rootNode = response.getRootJSONObj();
        JSONObject infoNode = rootNode.getJSONObject("authorization_info");
        authorizationInfo.setAuthorizerAppId( infoNode.getString("authorizer_appid") );
        authorizationInfo.setExpiresIn( infoNode.getInt("expires_in"));
        authorizationInfo.setAuthorizerAccessToken( infoNode.getString("authorizer_access_token") );
        authorizationInfo.setAuthorizerRefershToken( infoNode.getString("authorizer_refresh_token") );

        List<Integer> funcIds = Lists.newArrayList();
        JSONArray funcInfoArray = infoNode.getJSONArray("func_info");
        for(int i=0; i<funcInfoArray.size(); i++){
        	JSONObject funcInfoNode = funcInfoArray.getJSONObject(i);
        	JSONObject funcscopeCategoryNode = funcInfoNode.getJSONObject("funcscope_category");
        	Integer permissionId = funcscopeCategoryNode.getInt("id");
        	funcIds.add(permissionId);
        	
        	 // NOTE: 内获取菜单权限
//            if (permissionId.intValue() == WechatPermission.MESSAGE_AND_MENU.getValue()) {
//                ids.add(permissionId);
//            }
        }
        authorizationInfo.setFuncsByList(funcIds);
        return authorizationInfo;
    }

    
    /**
     * @Description  : 获取授权方信息
     * @Author       : zhenyujian
     * @Date         : 2015年12月3日 下午2:45:43 
     *
     * @Return       : Map<String,Object>
     */
    public static AuthorizerInfo requestAuthorizerInfo(String componentAppId, String componentAccessToken, String authorizerAppId)  throws WechatException, WebServiceException{
	    WechatApiResponse response = OpenPlatApiCaller.requestAuthorizerInfo(componentAppId, componentAccessToken, authorizerAppId);
	    
        try {
        	JSONObject rootNode = response.getRootJSONObj();
        	JSONObject infoNode = rootNode.getJSONObject("authorizer_info");
            
        	AuthorizerInfo authorizerInfo = new AuthorizerInfo();
        	authorizerInfo.setNickName( infoNode.optString("nick_name","") );
        	authorizerInfo.setUserName( infoNode.optString("user_name","") );
        	authorizerInfo.setHeadImg( infoNode.optString("head_img","") );
        	authorizerInfo.setAlias( infoNode.optString("alias","") );
        	authorizerInfo.setQrcodeUrl( infoNode.optString("qrcode_url","") );

            JSONObject serviceTypeInfoNode = infoNode.getJSONObject("service_type_info");
            authorizerInfo.setServiceType( serviceTypeInfoNode.optInt("id",0) );

            JSONObject verifyTypeInfoNode = infoNode.getJSONObject("verify_type_info");
            authorizerInfo.setVerifyType( verifyTypeInfoNode.optInt("id",0) );

            return authorizerInfo;

        } catch (Exception e) {
            logger.error("wechat - parse response exception - ", e);
            throw new RuntimeException("unexpected response: " + response);
        }
    }

    
    /**
     * @Description  : 获取（刷新）授权公众号的令牌
     * @Author       : zhenyujian
     * @Date         : 2015年12月3日 下午2:45:45 
     *
     * @Return       : Map<String,Object>
     */
    public static WechatApiResponse requestAuthorizerAccessToken(String componentAppId, String componentAccessToken,
    															   String authorizerAppId, String authorizerRefreshToken)  throws WechatException, WebServiceException{
    	try{
    		return OpenPlatApiCaller.requestAuthorizerAccessToken(componentAppId, componentAccessToken, authorizerAppId, authorizerRefreshToken);
    	}catch(WechatException e){
    		if(e.getErrorCode().equals( SalWechatErrorCode.WECHAT_ACCESS_TOKEN_INVALID )){
    			throw new WechatException( SalWechatErrorCode.WECHAT_ACCESS_TOKEN_INVALID , "无效的微信component access token");
    		}
    		throw e;
    	}
    }
}

