/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.helper.autoreply;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForKeyword;

/**   
 * @title       : KeyWordMatcher 
 * @description : 关键次匹配
 * @author      : zhenyujian
 * @date        : 2016年1月13日 下午2:56:19 
 */
public class KeyWordMatcher {
	
	
	/**
	 * @Description  : 关键次匹配
	 * @Author       : zhenyujian
	 * @Date         : 2016年1月13日 下午2:57:04 
	 *
	 * @Return       : OrgWechatReplyForKeyword
	 */
	public static OrgWechatReplyForKeyword match(String receiveMsg, List<OrgWechatReplyForKeyword> replyList){
		List<OrgWechatReplyForKeyword> list = new ArrayList<OrgWechatReplyForKeyword>();
		
		JSONArray keywords;
		JSONObject keywordJson;
		String keyword;
		boolean isExactMatch;
		
		//关键词匹配
		for(OrgWechatReplyForKeyword tempReply:replyList){

			keywords = JSONArray.fromObject(tempReply.getKeywords());
			if(keywords.size()>0){
				for(int i=0; i<keywords.size(); i++){
					keywordJson = keywords.getJSONObject(i);//json格式 [{"keyword":"高中","isExactMatch":1}]
					keyword = keywordJson.optString("keyword","");
					isExactMatch = (keywordJson.optInt("isExactMatch",1)==1 ? true:false);
					if(StringUtils.isNotBlank(keyword)){
						if( (isExactMatch && receiveMsg.equals(keyword)) 
						  ||(!isExactMatch && receiveMsg.contains(keyword))){
							list.add(tempReply);
						}
					}
				}
			}
		}
		
		return list.isEmpty() ? null : list.get( new Random().nextInt(list.size()) );
	}
	
	
}

