
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.sal.wechat.dto.menu;

import com.fasterxml.jackson.annotation.JsonIgnore;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Nov 22, 2016
 * @Desc 点击类型菜单
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class ClickButton extends Button {

    @JsonIgnore
    private String content;

    public ClickButton() {
    }

    public ClickButton(String name) {
        super(name);
    }

    private String type = "click";
    private String key;

    @Override
    public String toString() {
        return "ClickButton [type=" + type + ", key=" + key + ", name=" + name + "]";
    }

}
