/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.sal.wechat.api;

import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.sal.wechat.dto.webauth.WebAuthDto;
import com.baijia.tianxiao.sal.wechat.dto.webauth.WebAuthorizationDto;

/**   
 * @title       : WebAuthService 
 * @description : 网页授权
 * @author      : zhenyujian
 * @date        : 2016年1月6日 下午9:13:21 
 */
public interface WebAuthService {

	//获取网页授权 - 用户信息
	public Fans getWechatUserByWebAuthCode(WebAuthDto webAuthDto);
	
	//获取网页授权 - 授权信息
	public WebAuthorizationDto getWebAuthorizationDtoByWebAuthCode(WebAuthDto webAuthDto);
	
	//获取网页授权地址(基本授权) 授权成功后会跳转至landingPage 并带有参数 &openId=
	public String getFansinfoLink(Integer orgId, String landingPage);
	
	//获取网页授权地址(用户授权) 授权成功后会跳转至landingPage 并带有参数 &openId=
	public String getFansinfoLink4UserInfoScope(Integer orgId, String landingPage);
	
	
}

