/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public class FileUtil {
    public static boolean mkdir(String f) throws Exception {
        File file = new File(f);
        file.mkdir();
        return true;
    }

    public static boolean delete(String f) throws Exception {
        File file = new File(f);
        file.delete();
        return true;
    }

    public static String read(String file) throws Exception {
        return FileUtil.read(file, null);
    }

    public static String read(InputStream in) throws Exception {
        return FileUtil.read(in, System.getProperty("file.encoding"));
    }

    public static String read(InputStream in, String encoding) throws Exception {
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = null;){
            br = new BufferedReader(new InputStreamReader(in, encoding));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
    }

    public static String read(String file, String encoding) throws Exception {
        try (BufferedInputStream result = null;){
            int conlen;
            result = new BufferedInputStream(new FileInputStream(file));
            byte[] cont = new byte[1024];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((conlen = result.read(cont)) >= 0) {
                baos.write(cont, 0, conlen);
            }
            if (encoding != null) {
                String string = new String(baos.toByteArray(), encoding);
                return string;
            }
            String string = new String(baos.toByteArray());
            return string;
        }
    }

    public static boolean write(String f, String s, boolean append) throws Exception {
        return FileUtil.write(f, s.getBytes(), append);
    }

    public static boolean write(String f, String s) throws Exception {
        return FileUtil.write(f, s.getBytes(), false);
    }

    public static boolean write(String f, byte[] b) throws Exception {
        return FileUtil.write(f, b, false);
    }

    public static boolean write(String f, byte[] b, boolean append) throws Exception {
        try (FileOutputStream fos = null;){
            File file = new File(FileUtil.getPath(f));
            if (!file.exists()) {
                file.mkdirs();
            }
            fos = new FileOutputStream(f, append);
            fos.write(b);
            boolean bl = true;
            return bl;
        }
    }

    public static Object readObject(String file) throws Exception {
        try (ObjectInputStream ois = null;){
            Object obj;
            ois = new ObjectInputStream(new FileInputStream(file));
            Object object = obj = ois.readObject();
            return object;
        }
    }

    public static boolean writeObject(String f, Object o) throws Exception {
        try (ObjectOutputStream oos = null;){
            File file = new File(FileUtil.getPath(f));
            if (!file.exists()) {
                file.mkdirs();
            }
            oos = new ObjectOutputStream(new FileOutputStream(f));
            oos.writeObject(o);
            boolean bl = true;
            return bl;
        }
    }

    public static boolean writeGZIPFile(String f, String s) throws Exception {
        return FileUtil.writeGZIPFile(f, s.getBytes());
    }

    public static boolean writeGZIPFile(String f, byte[] b) throws Exception {
        try (DeflaterOutputStream fos = null;){
            File file = new File(FileUtil.getPath(f));
            if (!file.exists()) {
                file.mkdirs();
            }
            fos = new GZIPOutputStream(new FileOutputStream(f));
            fos.write(b);
            boolean bl = true;
            return bl;
        }
    }

    public static String getExtension(String file) {
        String extName = "";
        int idx = file.lastIndexOf(".");
        if (idx > 0) {
            extName = new String(file.substring(idx + 1));
        }
        return extName.trim();
    }

    public static String getFormatedExtension(String file) {
        return FileUtil.getExtension(file).toLowerCase();
    }

    private static String getPath(String f) {
        return f.substring(0, f.lastIndexOf(File.separator));
    }
}

