/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.task;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskHelper {
    private Logger logger = LoggerFactory.getLogger(TaskHelper.class);
    private static final int MIN_THREAD_POOL_SIZE = 5;
    private static final int MAX_THREAD_POOL_SIZE = 10;
    private static final int MAX_TASK_QUEUE_SIZE = 100;
    private static ExecutorService threadPool;
    private static ArrayBlockingQueue<Runnable> taskQueue;
    private static Object lock;
    private Thread taskManager;
    private static TaskHelper taskHelper;

    private TaskHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TaskHelper getInstance() throws InterruptedException {
        if (null == taskHelper) {
            Object object = lock;
            synchronized (object) {
                if (null == taskHelper) {
                    taskHelper = new TaskHelper();
                    taskQueue = new ArrayBlockingQueue(100);
                    int alSize = Runtime.getRuntime().availableProcessors();
                    alSize = alSize > 5 ? alSize : 5;
                    alSize = alSize > 10 ? 10 : alSize;
                    threadPool = Executors.newFixedThreadPool(alSize);
                    TaskHelper.taskHelper.taskManager = new Thread(new TaskManager());
                    TaskHelper.taskHelper.taskManager.start();
                    while (!TaskHelper.taskHelper.taskManager.isAlive()) {
                        Thread.sleep(100L);
                    }
                }
            }
        }
        return taskHelper;
    }

    public void addTask(Runnable task) throws InterruptedException {
        this.logger.info("addTask - task:{}", (Object)task);
        if (task != null && !taskQueue.offer(task)) {
            this.logger.error("TaskHelper - addTask - sending Queue has reached max element ", (Object)100);
        }
    }

    static {
        lock = new Object();
        taskHelper = null;
    }

    static class TaskManager
    implements Runnable {
        private Logger logger = LoggerFactory.getLogger(TaskManager.class);

        TaskManager() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Runnable task = (Runnable)taskQueue.take();
                        threadPool.execute(task);
                        Thread.sleep(10L);
                    }
                }
                catch (InterruptedException e) {
                    this.logger.error("TaskHelper - TaskManager e:{}", (Throwable)e);
                    continue;
                }
                break;
            }
        }
    }
}

