/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.sal.wechat.helper.autoreply;

import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForKeyword;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatReplyForSubscribe;
import com.baijia.tianxiao.sal.wechat.constant.MediaType;
import com.baijia.tianxiao.sal.wechat.helper.autoreply.PassiveReplyMsgBuilder;
import com.baijia.tianxiao.util.ShortUrlUtil;
import java.io.UnsupportedEncodingException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PassiveReplyMsgHelper {
    private static final Logger log = LoggerFactory.getLogger(PassiveReplyMsgHelper.class);

    public static String getSubscribeReply(String fromUser, String toUser, OrgWechatReplyForSubscribe reply) {
        String result = "success";
        if (reply == null) {
            return result;
        }
        try {
            MediaType type = MediaType.getByVaule(reply.getMediaType());
            if (MediaType.UNKNOWN == type) {
                return result;
            }
            if (MediaType.IMAGE == type) {
                if (StringUtils.isNotBlank((CharSequence)reply.getMediaId())) {
                    result = PassiveReplyMsgBuilder.imageMsg(fromUser, toUser, reply.getMediaId());
                }
            } else if (MediaType.VOICE != type && MediaType.VIDEO != type && MediaType.THUMB != type && MediaType.NEWS != type) {
                if (MediaType.CONTENT == type) {
                    if (StringUtils.isNotBlank((CharSequence)reply.getContent())) {
                        result = PassiveReplyMsgBuilder.textMsg(fromUser, toUser, reply.getContent());
                    }
                } else if ((MediaType.WANGXIAOZHUYE == type || MediaType.KECHENGDANYE == type || MediaType.HUODONG == type || MediaType.KECHENGLIEBIAO == type || MediaType.ZIDINGYILIANJIE == type || MediaType.WODEKEBIAO == type || MediaType.WODEPINGJIA == type || MediaType.GERENZHONGXIN == type) && StringUtils.isNotBlank((CharSequence)reply.getUrl())) {
                    String fmt = "\u3010%s\u3011\n%s";
                    fmt = String.format(fmt, type.getLabel(), reply.getUrl());
                    result = PassiveReplyMsgBuilder.textMsg(fromUser, toUser, fmt);
                }
            }
        }
        catch (Exception e) {
            log.error("wechat - PassiveReplyMsgHelper - sendSubscribeReply fail - fromUser:{}, toUser:{}, reply:{}", new Object[]{fromUser, toUser, reply});
        }
        return result;
    }

    public static String getKeywordReply(String fromUser, String toUser, OrgWechatReplyForKeyword reply) {
        log.info("from user : {} and to User:{} ", (Object)fromUser, (Object)toUser);
        String result = "success";
        if (reply == null) {
            return result;
        }
        try {
            MediaType type = MediaType.getByVaule(reply.getMediaType());
            if (MediaType.UNKNOWN == type) {
                return result;
            }
            if (MediaType.IMAGE == type) {
                if (StringUtils.isNotBlank((CharSequence)reply.getMediaId())) {
                    result = PassiveReplyMsgBuilder.imageMsg(fromUser, toUser, reply.getMediaId());
                }
            } else if (MediaType.VOICE != type && MediaType.VIDEO != type && MediaType.THUMB != type && MediaType.NEWS != type) {
                if (MediaType.CONTENT == type) {
                    if (StringUtils.isNotBlank((CharSequence)reply.getContent())) {
                        result = PassiveReplyMsgBuilder.textMsg(fromUser, toUser, reply.getContent());
                    }
                } else if ((MediaType.WANGXIAOZHUYE == type || MediaType.KECHENGDANYE == type || MediaType.HUODONG == type || MediaType.KECHENGLIEBIAO == type || MediaType.ZIDINGYILIANJIE == type || MediaType.WODEKEBIAO == type || MediaType.WODEPINGJIA == type || MediaType.GERENZHONGXIN == type) && StringUtils.isNotBlank((CharSequence)reply.getUrl())) {
                    String fmt = "\u3010%s\u3011\n%s";
                    fmt = String.format(fmt, type.getLabel(), PassiveReplyMsgHelper.addTargetOpenId(reply.getUrl(), toUser));
                    result = PassiveReplyMsgBuilder.textMsg(fromUser, toUser, fmt);
                }
            }
        }
        catch (Exception e) {
            log.error("error is : ", (Throwable)e);
            log.error("wechat - getKeywordReply - sendSubscribeReply fail - fromUser:{}, toUser:{}, reply:{}", new Object[]{fromUser, toUser, reply});
        }
        return result;
    }

    public static String addTargetOpenId(String url, String toOpenId) throws UnsupportedEncodingException {
        if (url.contains("activityId") && url.contains("activityType")) {
            if (url.startsWith("http://") && url.contains("https://")) {
                url = url.substring("http://".length());
            }
            int firstIndex = url.indexOf("landingPage");
            int lastIndex = url.indexOf("activityId", firstIndex);
            String firStr = url.substring(0, lastIndex);
            String lastStr = url.substring(lastIndex);
            String dengyu = "%253D";
            String yuhao = "%2526";
            lastStr = yuhao + lastStr;
            url = firStr + "targetOpenId" + dengyu + toOpenId + lastStr;
            log.info("targetUrl is : {} ", (Object)url);
            url = ShortUrlUtil.getShortUrl((String)url);
            System.out.println(url);
        } else {
            log.info("need not to change for url : {} ", (Object)url);
        }
        return url;
    }

    public static void main(String[] args) throws Exception {
        PassiveReplyMsgHelper.addTargetOpenId("https://open.weixin.qq.com/connect/oauth2/authorize?&appid=wx227be953e1c83a0b&redirect_uri=http%3A%2F%2Ftest-crm-m.ctest.baijiahulian.com%2Fwechat%2Fwebauth%2Ffansinfo.do%3F%26landingPage%3Dhttp%253A%252F%252Ftest-marketing-m.ctest.baijiahulian.com%252F%252Fgua.html%253FtemplateId%253D8%2526activityId%253D352%2526activityType%253D8%26scope%3Dsnsapi_base&response_type=code&scope=snsapi_base&state=&component_appid=wxe3e8b29a095c7a4f#wechat_redirect", "");
    }
}

